/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.LoadBalancer;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.net.NebulaPool;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPoolFactory
extends BasePooledObjectFactory<NebulaClient>
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadBalancer loadBalancer;
    private final NebulaPool.Builder builder;

    public ClientPoolFactory(LoadBalancer loadBalancer, NebulaPool.Builder builder) {
        this.loadBalancer = loadBalancer;
        this.builder = builder;
    }

    public NebulaClient create() throws IOErrorException, AuthFailedException {
        List<HostAddress> goodHosts = this.loadBalancer.getGoodAddresses();
        if (goodHosts.size() == 0) {
            throw new IOErrorException(1, "No servers host is available, please check your servers is up and network between client and server is connected.");
        }
        String addrStr = goodHosts.stream().map(HostAddress::toString).collect(Collectors.joining(","));
        NebulaClient client = NebulaClient.builder(addrStr, this.builder.userName).withAuthOptions(this.builder.authOptions).withConnectTimeoutMills(this.builder.connectTimeoutMills).withRequestTimeoutMills(this.builder.requestTimeoutMills).withScanParallel(this.builder.scanParallel).withEnableTls(this.builder.enableTls).withTlsCa(this.builder.tlsCa).withTlsCert(this.builder.tlsCert, this.builder.tlsKey).withTlsPeerName(this.builder.tlsPeerName).build();
        try {
            String stmt;
            ResultSet resultSet;
            if (this.builder.schema != null && !(resultSet = client.execute(stmt = String.format("SESSION SET SCHEMA \"%s\"", this.builder.schema))).isSucceeded()) {
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            if (this.builder.graph != null && !(resultSet = client.execute(stmt = String.format("SESSION SET GRAPH \"%s\"", this.builder.graph))).isSucceeded()) {
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            if (this.builder.timeZone != null && !(resultSet = client.execute(stmt = String.format("SESSION SET TIME ZONE \"%s\"", this.builder.timeZone))).isSucceeded()) {
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            if (!this.builder.parameters.isEmpty()) {
                ResultSet result;
                StringBuilder parametersSetStatement = new StringBuilder();
                parametersSetStatement.append("SESSION SET VALUE ");
                for (Map.Entry<String, String> parameter : this.builder.parameters.entrySet()) {
                    parametersSetStatement.append("$").append(parameter.getKey()).append("=").append(parameter.getValue()).append(",");
                }
                parametersSetStatement.deleteCharAt(parametersSetStatement.length() - 1);
                if (!parametersSetStatement.toString().isEmpty() && !(result = client.execute(parametersSetStatement.toString())).isSucceeded()) {
                    throw new RuntimeException(String.format("%s failed for %s", parametersSetStatement, result.getErrorMessage()));
                }
            }
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
        return client;
    }

    public PooledObject<NebulaClient> wrap(NebulaClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<NebulaClient> clientObject) throws Exception {
        NebulaClient client = (NebulaClient)clientObject.getObject();
        try {
            client.close();
        }
        catch (Exception e) {
            this.logger.warn("session release failed ", (Throwable)e);
        }
        super.destroyObject(clientObject);
    }

    public boolean validateObject(PooledObject<NebulaClient> clientObject) {
        NebulaClient client = (NebulaClient)clientObject.getObject();
        return client.ping();
    }
}

