/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.decode.datatype.VectorType;
import com.vesoft.nebula.proto.graph.NestedVector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.commons.codec.Charsets;

public class DecodeUtils {
    public static final Charset charset = Charsets.UTF_8;

    public static int bytesToInt8(ByteString data) {
        return data.byteAt(0);
    }

    public static int bytesToUInt8(ByteString data) {
        return data.byteAt(0) & 0xFF;
    }

    public static Short bytesToInt16(ByteString data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray());
        return buffer.order(order).getShort();
    }

    public static int bytesToUInt16(ByteString data, ByteOrder order) {
        return DecodeUtils.bytesToInt16(data, order) & 0xFFFF;
    }

    public static int bytesToInt32(ByteString data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray());
        return buffer.order(order).getInt();
    }

    public static long bytesToUInt32(ByteString data, ByteOrder order) {
        return Integer.toUnsignedLong(DecodeUtils.bytesToInt32(data, order));
    }

    public static long bytesToInt64(ByteString data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray());
        return buffer.order(order).getLong();
    }

    public static float bytesToFloat(ByteString data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray());
        return buffer.order(order).getFloat();
    }

    public static double bytesToDouble(ByteString data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray());
        return buffer.order(order).getDouble();
    }

    public static boolean bytesToBool(ByteString data) {
        return data.byteAt(0) == 1;
    }

    public static String bytesToSizedString(ByteString data, int startPos, ByteOrder byteOrder) {
        short length = DecodeUtils.bytesToInt16(data.substring(startPos, 2 + startPos), byteOrder);
        ByteString strBytes = data.substring(startPos += 2, startPos + length);
        return strBytes.toString(charset);
    }

    public static VectorType getVectorType(NestedVector vector) {
        int type = vector.getCommonMetaData().getVectorContentType();
        return VectorType.getVectorType(type & 0xFF);
    }

    public static boolean isNullBitMapAllSet(NestedVector vector) {
        int type = vector.getCommonMetaData().getVectorContentType();
        return (type & 0x100) != 0;
    }
}

