/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import java.nio.ByteOrder;

public class BytesReader {
    private ByteString data;
    private int index;

    public BytesReader(ByteString data) {
        this.data = data;
        this.index = 0;
    }

    public ByteString read(int len) {
        ByteString byteString = this.data.substring(this.index, this.index + len);
        this.index += len;
        return byteString;
    }

    public String readSizedString(ByteOrder byteOrder) {
        short length = DecodeUtils.bytesToInt16(this.read(2), byteOrder);
        int startIndex = this.index;
        this.index += length;
        ByteString strBytes = this.data.substring(startIndex, startIndex + length);
        return strBytes.toString(DecodeUtils.charset);
    }
}

