/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.datatype;

import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.decode.datatype.DataType;
import com.vesoft.nebula.driver.graph.decode.datatype.EdgeType;
import com.vesoft.nebula.driver.graph.decode.datatype.NodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathType
extends DataType {
    private final List<DataType> dataTypes;
    private final List<NodeType> nodeTypes = new ArrayList<NodeType>();
    private final List<EdgeType> edgeTypes = new ArrayList<EdgeType>();

    public PathType(List<DataType> dataTypes) {
        super(ColumnType.COLUMN_TYPE_PATH);
        this.dataTypes = dataTypes;
        for (DataType dataType : dataTypes) {
            if (dataType.getType() == ColumnType.COLUMN_TYPE_NODE) {
                this.nodeTypes.add((NodeType)dataType);
            }
            if (dataType.getType() != ColumnType.COLUMN_TYPE_EDGE) continue;
            this.edgeTypes.add((EdgeType)dataType);
        }
    }

    public List<DataType> getDataTypes() {
        return this.dataTypes;
    }

    public Map<Integer, Map<Integer, Map<String, DataType>>> getNodeTypes() {
        HashMap<Integer, Map<Integer, Map<String, DataType>>> nodeTypesMap = new HashMap<Integer, Map<Integer, Map<String, DataType>>>();
        for (NodeType nodeType : this.nodeTypes) {
            nodeTypesMap.putAll(nodeType.getNodeTypes());
        }
        return nodeTypesMap;
    }

    public Map<Integer, Map<Integer, Map<String, DataType>>> getEdgeTypes() {
        HashMap<Integer, Map<Integer, Map<String, DataType>>> edgeTypesMap = new HashMap<Integer, Map<Integer, Map<String, DataType>>>();
        for (EdgeType edgeType : this.edgeTypes) {
            edgeTypesMap.putAll(edgeType.getEdgeTypes());
        }
        return edgeTypesMap;
    }
}

