/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.proto.graph.PlanInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PlanInfoNode
implements Serializable {
    private PlanInfo planInfo;
    private String id;
    private String name;
    private String details;
    private double timeMs;
    private long rows;
    private double memoryKib;
    private double blockedMs;
    private double queuedMs;
    private double consumeMs;
    private double produceMs;
    private double finishMs;
    private long batches;
    private long concurrency;
    private String otherStatsJson;
    private List<PlanInfoNode> children;

    protected PlanInfoNode(PlanInfo planInfo) {
        this.planInfo = planInfo;
        this.id = planInfo.getId().toString(DecodeUtils.charset);
        this.name = planInfo.getName().toString(DecodeUtils.charset);
        this.details = planInfo.getDetails().toString(DecodeUtils.charset);
        this.timeMs = planInfo.getTimeMs();
        this.rows = planInfo.getRows();
        this.memoryKib = planInfo.getMemoryKib();
        this.blockedMs = planInfo.getBlockedMs();
        this.queuedMs = planInfo.getQueuedMs();
        this.consumeMs = planInfo.getConsumeMs();
        this.produceMs = planInfo.getProduceMs();
        this.finishMs = planInfo.getFinishMs();
        this.batches = planInfo.getBatches();
        this.concurrency = planInfo.getConcurrency();
        this.otherStatsJson = planInfo.getOtherStatsJson().toString(DecodeUtils.charset);
        ArrayList<PlanInfoNode> planNodes = new ArrayList<PlanInfoNode>();
        for (PlanInfo plan : planInfo.getChildrenList()) {
            planNodes.add(new PlanInfoNode(plan));
        }
        this.children = planNodes;
    }

    public String getPlanId() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDetails() {
        return this.details;
    }

    public double getTimeMs() {
        return this.timeMs;
    }

    public long getRows() {
        return this.rows;
    }

    public double getMemoryKib() {
        return this.memoryKib;
    }

    public double getBlockedMs() {
        return this.blockedMs;
    }

    public List<PlanInfoNode> getChildren() {
        return this.children;
    }
}

