/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.net.LoadBalancer;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLoadBalancer
implements LoadBalancer,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinLoadBalancer.class);
    private static final int S_OK = 0;
    private static final int S_BAD = 1;
    private final List<HostAddress> addresses = new ArrayList<HostAddress>();
    private final Map<HostAddress, Integer> serversStatus = new ConcurrentHashMap<HostAddress, Integer>();
    private final boolean strictlyServerHealthy;
    private final String userName;
    private final Map<String, Object> authOptions;
    private final AtomicInteger pos = new AtomicInteger(0);
    private ScheduledExecutorService schedule;

    public RoundRobinLoadBalancer(List<HostAddress> addresses, String userName, Map<String, Object> authOptions, boolean strictlyServerHealthy, long healthCheckTime) {
        for (HostAddress addr : addresses) {
            this.addresses.add(addr);
            this.serversStatus.put(addr, 1);
        }
        this.strictlyServerHealthy = strictlyServerHealthy;
        this.userName = userName;
        this.authOptions = authOptions;
        if (healthCheckTime > 0L) {
            this.schedule = Executors.newScheduledThreadPool(1);
            this.schedule.scheduleAtFixedRate(this::scheduleTask, 0L, healthCheckTime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() {
        if (this.schedule != null && !this.schedule.isShutdown()) {
            this.schedule.shutdownNow();
        }
    }

    @Override
    public HostAddress getAddress() {
        if (this.pos.get() == Integer.MAX_VALUE) {
            this.pos.set(0);
        }
        int tryCount = 0;
        while (++tryCount <= this.addresses.size()) {
            int newPos = this.pos.getAndIncrement() % this.addresses.size();
            HostAddress addr = this.addresses.get(newPos);
            if (this.serversStatus.get(addr) != 0) continue;
            return addr;
        }
        return null;
    }

    @Override
    public void updateServersStatus() {
        for (HostAddress hostAddress : this.addresses) {
            if (this.ping(hostAddress)) {
                this.serversStatus.put(hostAddress, 0);
                continue;
            }
            this.serversStatus.put(hostAddress, 1);
        }
    }

    @Override
    public List<HostAddress> getGoodAddresses() {
        ArrayList<HostAddress> goodHosts = new ArrayList<HostAddress>();
        for (Map.Entry<HostAddress, Integer> server : this.serversStatus.entrySet()) {
            if (server.getValue() != 0) continue;
            goodHosts.add(server.getKey());
        }
        return goodHosts;
    }

    public boolean ping(HostAddress addr) {
        try {
            NebulaClient client = NebulaClient.builder(addr.toString(), this.userName).withAuthOptions(this.authOptions).build();
            client.close();
            return true;
        }
        catch (Exception e) {
            logger.error("ping failed, ", e);
            return false;
        }
    }

    @Override
    public boolean isServersOK() {
        this.updateServersStatus();
        int numServersWithOkStatus = 0;
        int numServersWithBadStatus = 0;
        for (HostAddress hostAddress : this.addresses) {
            if (this.serversStatus.get(hostAddress) == 0) {
                ++numServersWithOkStatus;
                continue;
            }
            ++numServersWithBadStatus;
        }
        return this.strictlyServerHealthy && numServersWithBadStatus == 0 || !this.strictlyServerHealthy && numServersWithOkStatus > 0;
    }

    private void scheduleTask() {
        this.updateServersStatus();
    }
}

