/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.BaseDataObject;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.proto.common.Node;
import com.vesoft.nebula.proto.common.Value;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Vertex
extends BaseDataObject {
    private final Node node;

    public Vertex(Node node) {
        if (node == null) {
            throw new RuntimeException("Input an null node object");
        }
        this.node = node;
    }

    public String getGraph() {
        return this.node.getGraph();
    }

    public String getType() {
        return this.node.getType();
    }

    public List<String> getLabels() {
        return this.node.getLabelsList();
    }

    public long getId() {
        return this.node.getNodeId();
    }

    public List<String> getColumnNames() throws UnsupportedEncodingException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String name : this.node.getPropertiesMap().keySet()) {
            keys.add(new String(name));
        }
        return keys;
    }

    public List<ValueWrapper> getValues() {
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Map.Entry<String, Value> kv : this.node.getPropertiesMap().entrySet()) {
            values.add(new ValueWrapper(kv.getValue()));
        }
        return values;
    }

    public Map<String, ValueWrapper> getProperties() {
        HashMap<String, ValueWrapper> props = new HashMap<String, ValueWrapper>();
        for (Map.Entry<String, Value> p : this.node.getPropertiesMap().entrySet()) {
            props.put(p.getKey(), new ValueWrapper(p.getValue()));
        }
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex node = (Vertex)o;
        return this.getId() == node.getId();
    }

    public int hashCode() {
        return Objects.hash(this.node, this.getDecodeType());
    }

    public String toString() {
        Map<String, ValueWrapper> props = this.getProperties();
        ArrayList<String> propStrs = new ArrayList<String>();
        for (String propName : props.keySet()) {
            propStrs.add(propName + ":" + props.get(propName).toString());
        }
        return String.format("(%d@%s:%s{%s})", this.getId(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)",", propStrs));
    }
}

