/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.Relationship;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.data.Vertex;
import com.vesoft.nebula.proto.common.Path;
import com.vesoft.nebula.proto.common.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NPath {
    private Path path;
    private String decodeType = "utf-8";
    private List<Vertex> nodes = new ArrayList<Vertex>();
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private List<ValueWrapper> values = new ArrayList<ValueWrapper>();

    public NPath(Path path) {
        if (path == null) {
            return;
        }
        this.path = path;
        for (Value value : path.getValuesList()) {
            this.values.add(new ValueWrapper(value));
            if (new ValueWrapper(value).isNode()) {
                this.nodes.add(new Vertex(value.getNodeValue()));
            }
            if (!new ValueWrapper(value).isEdge()) continue;
            this.relationships.add(new Relationship(value.getEdgeValue()));
        }
    }

    public List<Vertex> nodes() {
        return this.nodes;
    }

    public List<Relationship> relationships() {
        return this.relationships;
    }

    public List<ValueWrapper> values() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NPath that = (NPath)obj;
        return this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        ArrayList<String> edgeStrs = new ArrayList<String>();
        for (int i = 0; i < this.relationships.size(); ++i) {
            String template;
            Relationship relationship = this.relationships.get(i);
            ArrayList<String> edgePropStrs = new ArrayList<String>();
            HashMap<String, ValueWrapper> props = relationship.getProperties();
            for (String key : props.keySet()) {
                edgePropStrs.add(key + ":" + ((ValueWrapper)props.get(key)).toString());
            }
            Vertex prefixNode = this.nodes.get(i);
            ArrayList<String> prefixNodePropStrs = new ArrayList<String>();
            Map<String, ValueWrapper> prefixNodeProps = prefixNode.getProperties();
            for (String key : prefixNodeProps.keySet()) {
                prefixNodePropStrs.add(key + ":" + prefixNodeProps.get(key).toString());
            }
            Vertex suffixNode = this.nodes.get(i + 1);
            ArrayList<String> suffixNodePropStrs = new ArrayList<String>();
            Map<String, ValueWrapper> suffixNodeProps = suffixNode.getProperties();
            for (String key : suffixNodeProps.keySet()) {
                suffixNodePropStrs.add(key + ":" + suffixNodeProps.get(key).toString());
            }
            if (i == 0) {
                template = "(%d@%s:%s{%s})~[%d@%s:%s{%s}]~(%d@%s:%s{%s})";
                if (relationship.isDirected() && relationship.getSrcId() == prefixNode.getId()) {
                    template = "(%d@%s:%s{%s})-[%d@%s:%s{%s}]->(%d@%s:%s{%s})";
                }
                if (relationship.isDirected() && relationship.getSrcId() != prefixNode.getId()) {
                    template = "(%d@%s:%s{%s})<-[%d@%s:%s{%s}]-(%d@%s:%s{%s})";
                }
                edgeStrs.add(String.format(template, prefixNode.getId(), prefixNode.getType(), String.join((CharSequence)"&", prefixNode.getLabels()), String.join((CharSequence)",", prefixNodePropStrs), relationship.getRank(), relationship.getType(), String.join((CharSequence)"&", relationship.getLabels()), String.join((CharSequence)",", edgePropStrs), suffixNode.getId(), suffixNode.getType(), String.join((CharSequence)"&", suffixNode.getLabels()), String.join((CharSequence)",", suffixNodePropStrs)));
                continue;
            }
            template = "~[%d@%s:%s{%s}]~(%d@%s:%s{%s})";
            if (relationship.isDirected() && relationship.getSrcId() == prefixNode.getId()) {
                template = "-[%d@%s:%s{%s}]->(%d@%s:%s{%s})";
            }
            if (relationship.isDirected() && relationship.getSrcId() != prefixNode.getId()) {
                template = "<-[%d@%s:%s{%s}]-(%d@%s:%s{%s})";
            }
            edgeStrs.add(String.format(template, relationship.getRank(), relationship.getType(), String.join((CharSequence)"&", relationship.getLabels()), String.join((CharSequence)",", edgePropStrs), suffixNode.getId(), suffixNode.getType(), String.join((CharSequence)"&", suffixNode.getLabels()), String.join((CharSequence)",", suffixNodePropStrs)));
        }
        return String.join((CharSequence)"", edgeStrs);
    }
}

