/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.facebook.thrift.TException;
import com.google.common.collect.Maps;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.meta.MetaCache;
import com.vesoft.nebula.client.meta.MetaClient;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.HostItem;
import com.vesoft.nebula.meta.IdName;
import com.vesoft.nebula.meta.SpaceItem;
import com.vesoft.nebula.meta.TagItem;
import com.vesoft.nebula.util.NetUtil;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaManager
implements MetaCache,
Serializable {
    private Map<String, SpaceInfo> spacesInfo = new HashMap<String, SpaceInfo>();
    private Map<String, Map<Integer, HostAddr>> partLeaders = null;
    private Map<HostAddr, HostAddr> storageAddressMapping = new ConcurrentHashMap<HostAddr, HostAddr>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaManager.class);
    private MetaClient metaClient;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int DEFAULT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_CONNECTION_RETRY_SIZE = 3;
    private static final int DEFAULT_EXECUTION_RETRY_SIZE = 3;

    public MetaManager(List<HostAddress> address) throws TException, ClientServerIncompatibleException, UnknownHostException {
        this.metaClient = new MetaClient(address);
        this.metaClient.connect();
        this.fillMetaInfo();
    }

    public MetaManager(List<HostAddress> address, int timeout, int connectionRetry, int executionRetry, boolean enableSSL, SSLParam sslParam) throws TException, ClientServerIncompatibleException, UnknownHostException {
        this.metaClient = new MetaClient(address, timeout, connectionRetry, executionRetry, enableSSL, sslParam);
        this.metaClient.connect();
        this.fillMetaInfo();
    }

    public void addStorageAddrMapping(String sourceAddr, String targetAddr) {
        if (sourceAddr != null && targetAddr != null) {
            this.storageAddressMapping.put(NetUtil.parseHostAddr(sourceAddr), NetUtil.parseHostAddr(targetAddr));
        }
    }

    public void addStorageAddrMapping(Map<String, String> addressMap) {
        if (addressMap != null && !addressMap.isEmpty()) {
            for (Map.Entry<String, String> et : addressMap.entrySet()) {
                this.storageAddressMapping.put(NetUtil.parseHostAddr(et.getKey()), NetUtil.parseHostAddr(et.getValue()));
            }
        }
    }

    public void close() {
        this.metaClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMetaInfo() {
        try {
            HashMap<String, SpaceInfo> tempSpacesInfo = new HashMap<String, SpaceInfo>();
            List<IdName> spaces = this.metaClient.getSpaces();
            for (IdName space : spaces) {
                SpaceInfo spaceInfo = new SpaceInfo();
                String spaceName = new String(space.name);
                SpaceItem spaceItem = this.metaClient.getSpace(spaceName);
                spaceInfo.spaceItem = spaceItem;
                List<TagItem> tags = this.metaClient.getTags(spaceName);
                for (TagItem tagItem : tags) {
                    String tagName = new String(tagItem.tag_name);
                    if (spaceInfo.tagItems.containsKey(tagName) && ((TagItem)spaceInfo.tagItems.get(tagName)).getVersion() >= tagItem.getVersion()) continue;
                    spaceInfo.tagItems.put(tagName, tagItem);
                    spaceInfo.tagIdNames.put(tagItem.tag_id, tagName);
                }
                List<EdgeItem> edges = this.metaClient.getEdges(spaceName);
                for (EdgeItem edge : edges) {
                    String edgeName = new String(edge.edge_name);
                    if (spaceInfo.edgeItems.containsKey(edgeName) && ((EdgeItem)spaceInfo.edgeItems.get(edgeName)).getVersion() >= edge.getVersion()) continue;
                    spaceInfo.edgeItems.put(edgeName, edge);
                    spaceInfo.edgeTypeNames.put(edge.edge_type, edgeName);
                }
                spaceInfo.partsAlloc = this.metaClient.getPartsAlloc(spaceName);
                tempSpacesInfo.put(spaceName, spaceInfo);
            }
            try {
                this.lock.writeLock().lock();
                this.spacesInfo = tempSpacesInfo;
                if (this.partLeaders == null) {
                    this.partLeaders = new HashMap<String, Map<Integer, HostAddr>>();
                }
                for (HostItem hostItem : this.metaClient.getHostItems()) {
                    HostAddr leader = hostItem.getHostAddr();
                    for (Map.Entry<byte[], List<Integer>> spaceParts : hostItem.getLeader_parts().entrySet()) {
                        String space = new String(spaceParts.getKey(), Charsets.UTF_8);
                        if (!this.partLeaders.containsKey(space)) {
                            this.partLeaders.put(space, Maps.newConcurrentMap());
                        }
                        Iterator<Comparable<TagItem>> iterator = spaceParts.getValue().iterator();
                        while (iterator.hasNext()) {
                            int n = (Integer)iterator.next();
                            this.partLeaders.get(space).put(n, leader);
                        }
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (TException | ExecuteFailedException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public int getSpaceId(String spaceName) throws IllegalArgumentException {
        return this.getSpace((String)spaceName).space_id;
    }

    @Override
    public SpaceItem getSpace(String spaceName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("space:" + spaceName + " does not exist.");
            }
            SpaceItem spaceItem = this.spacesInfo.get(spaceName).spaceItem;
            return spaceItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getTagId(String spaceName, String tagName) throws IllegalArgumentException {
        return this.getTag((String)spaceName, (String)tagName).tag_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagItem getTag(String spaceName, String tagName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName) || !this.spacesInfo.get(spaceName).tagItems.containsKey(tagName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.spacesInfo.get(spaceName).tagItems.containsKey(tagName)) {
                throw new IllegalArgumentException("Tag:" + tagName + " does not exist.");
            }
            TagItem tagItem = (TagItem)this.spacesInfo.get(spaceName).tagItems.get(tagName);
            return tagItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getEdgeType(String spaceName, String edgeName) throws IllegalArgumentException {
        return this.getEdge((String)spaceName, (String)edgeName).edge_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeItem getEdge(String spaceName, String edgeName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName) || !this.spacesInfo.get(spaceName).edgeItems.containsKey(edgeName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.spacesInfo.get(spaceName).edgeItems.containsKey(edgeName)) {
                throw new IllegalArgumentException("Edge:" + edgeName + " does not exist.");
            }
            EdgeItem edgeItem = (EdgeItem)this.spacesInfo.get(spaceName).edgeItems.get(edgeName);
            return edgeItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddr getLeader(String spaceName, int part) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (this.partLeaders == null) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.get(spaceName).containsKey(part)) {
                throw new IllegalArgumentException("PartId:" + part + " does not exist.");
            }
            HostAddr hostAddr = this.partLeaders.get(spaceName).get(part);
            HostAddr hostAddr2 = this.storageAddressMapping.getOrDefault(hostAddr, hostAddr);
            return hostAddr2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Integer> getSpaceParts(String spaceName) throws IllegalArgumentException {
        return new ArrayList<Integer>(this.getPartsAlloc(spaceName).keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, List<HostAddr>> getPartsAlloc(String spaceName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            Map partsAlloc = this.spacesInfo.get(spaceName).partsAlloc;
            if (!this.storageAddressMapping.isEmpty()) {
                partsAlloc.keySet().forEach(partId -> partsAlloc.computeIfPresent(partId, (k, addressList) -> addressList.stream().map(hostAddr -> this.storageAddressMapping.getOrDefault(hostAddr, (HostAddr)hostAddr)).collect(Collectors.toList())));
            }
            Map map = partsAlloc;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeader(String spaceName, int part, HostAddr newLeader) throws IllegalArgumentException {
        try {
            this.lock.writeLock().lock();
            if (this.partLeaders == null) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.get(spaceName).containsKey(part)) {
                throw new IllegalArgumentException("PartId:" + part + " does not exist.");
            }
            this.partLeaders.get(spaceName).put(part, newLeader);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<HostAddr> listHosts() {
        Set<HostAddr> hosts = this.metaClient.listHosts();
        if (!this.storageAddressMapping.isEmpty()) {
            hosts = hosts.stream().map(hostAddr -> this.storageAddressMapping.getOrDefault(hostAddr, (HostAddr)hostAddr)).collect(Collectors.toSet());
        }
        return hosts;
    }

    public int getConnectionRetry() {
        return this.metaClient.getConnectionRetry();
    }

    public int getTimeout() {
        return this.metaClient.getTimeout();
    }

    public int getExecutionRetry() {
        return this.metaClient.getExecutionRetry();
    }

    private class SpaceInfo {
        private SpaceItem spaceItem = null;
        private Map<String, TagItem> tagItems = new HashMap<String, TagItem>();
        private Map<Integer, String> tagIdNames = new HashMap<Integer, String>();
        private Map<String, EdgeItem> edgeItems = new HashMap<String, EdgeItem>();
        private Map<Integer, String> edgeTypeNames = new HashMap<Integer, String>();
        private Map<Integer, List<HostAddr>> partsAlloc = new HashMap<Integer, List<HostAddr>>();

        private SpaceInfo() {
        }
    }
}

