/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Session;
import com.vesoft.nebula.client.graph.net.SessionState;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaSession
implements Serializable {
    private static final long serialVersionUID = -88438249377120255L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long sessionID;
    private final int timezoneOffset;
    private SyncConnection connection;
    private final AtomicReference<SessionState> state = new AtomicReference();
    private final AtomicBoolean isReleased = new AtomicBoolean(false);

    public NebulaSession(SyncConnection connection, long sessionID, int timezoneOffset, SessionState state) {
        this.connection = connection;
        this.sessionID = sessionID;
        this.timezoneOffset = timezoneOffset;
        this.state.set(state);
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public Boolean isIdle() {
        return this.state.get() == SessionState.IDLE;
    }

    public Boolean isUsed() {
        return this.state.get() == SessionState.USED;
    }

    public boolean isUsedAndSetIdle() {
        return this.state.compareAndSet(SessionState.USED, SessionState.IDLE);
    }

    public boolean isIdleAndSetUsed() {
        return this.state.compareAndSet(SessionState.IDLE, SessionState.USED);
    }

    public ResultSet execute(String stmt) throws IOErrorException {
        return new ResultSet(this.connection.execute(this.sessionID, stmt), this.timezoneOffset);
    }

    public ResultSet executeWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.forEach((key, value) -> map.put(key.getBytes(), Session.value2Nvalue(value)));
        return new ResultSet(this.connection.executeWithParameter(this.sessionID, stmt, map), this.timezoneOffset);
    }

    public ResultSet executeWithTimeout(String stmt, long timeoutMs) throws IOErrorException {
        return this.executeWithParameterTimeout(stmt, Collections.EMPTY_MAP, timeoutMs);
    }

    public ResultSet executeWithParameterTimeout(String stmt, Map<String, Object> parameterMap, long timeoutMs) throws IOErrorException {
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.forEach((key, value) -> map.put(key.getBytes(), Session.value2Nvalue(value)));
        return new ResultSet(this.connection.executeWithParameterTimeout(this.sessionID, stmt, map, timeoutMs), this.timezoneOffset);
    }

    public String executeJsonWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.forEach((key, value) -> map.put(key.getBytes(), Session.value2Nvalue(value)));
        return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
    }

    public void release() {
        if (this.isReleased.get()) {
            return;
        }
        if (this.isReleased.compareAndSet(false, true)) {
            try {
                this.connection.signout(this.sessionID);
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }
}

