/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostStatus;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DrainerInfo
implements TBase,
Serializable,
Cloneable,
Comparable<DrainerInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("DrainerInfo");
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 8, 2);
    public HostAddr host;
    public HostStatus status;
    public static final int HOST = 1;
    public static final int STATUS = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public DrainerInfo() {
    }

    public DrainerInfo(HostAddr host, HostStatus status) {
        this();
        this.host = host;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DrainerInfo(DrainerInfo other) {
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        if (other.isSetStatus()) {
            this.status = TBaseHelper.deepCopy(other.status);
        }
    }

    @Override
    public DrainerInfo deepCopy() {
        return new DrainerInfo(this);
    }

    public HostAddr getHost() {
        return this.host;
    }

    public DrainerInfo setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public HostStatus getStatus() {
        return this.status;
    }

    public DrainerInfo setStatus(HostStatus status) {
        this.status = status;
        return this;
    }

    public void unsetStatus() {
        this.status = null;
    }

    public boolean isSetStatus() {
        return this.status != null;
    }

    public void setStatusIsSet(boolean __value) {
        if (!__value) {
            this.status = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetStatus();
                    break;
                }
                this.setStatus((HostStatus)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHost();
            }
            case 2: {
                return this.getStatus();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof DrainerInfo)) {
            return false;
        }
        DrainerInfo that = (DrainerInfo)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetStatus(), that.isSetStatus(), this.status, that.status);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.host, this.status});
    }

    @Override
    public int compareTo(DrainerInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatus()).compareTo(other.isSetStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.status, other.status);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.status = HostStatus.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.status != null) {
            oprot.writeFieldBegin(STATUS_FIELD_DESC);
            oprot.writeI32(this.status == null ? 0 : this.status.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("DrainerInfo");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("status");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getStatus() == null) {
            sb.append("null");
        } else {
            String status_name;
            String string = status_name = this.getStatus() == null ? "null" : this.getStatus().name();
            if (status_name != null) {
                sb.append(status_name);
                sb.append(" (");
            }
            sb.append(this.getStatus());
            if (status_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("status", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(DrainerInfo.class, metaDataMap);
    }

    public static class Builder {
        private HostAddr host;
        private HostStatus status;

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setStatus(HostStatus status) {
            this.status = status;
            return this;
        }

        public DrainerInfo build() {
            DrainerInfo result = new DrainerInfo();
            result.setHost(this.host);
            result.setStatus(this.status);
            return result;
        }
    }
}

