/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TThreadFactoryImpl
implements ThreadFactory {
    protected String id_;
    protected Long version_;
    protected ThreadGroup threadGroup_;
    protected final AtomicInteger threadNbr_ = new AtomicInteger(1);
    protected static final Map<String, Long> poolVersionByName = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TThreadFactoryImpl(String id) {
        Long lastVersion;
        SecurityManager sm = System.getSecurityManager();
        this.threadGroup_ = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        TThreadFactoryImpl tThreadFactoryImpl = this;
        synchronized (tThreadFactoryImpl) {
            lastVersion = poolVersionByName.get(id);
            if (lastVersion == null) {
                lastVersion = -1L;
            }
            poolVersionByName.put(id, lastVersion + 1L);
        }
        this.version_ = lastVersion != null ? lastVersion + 1L : 0L;
        this.id_ = id;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.id_ + "-" + this.version_ + "-thread-" + this.threadNbr_.getAndIncrement();
        Thread thread = new Thread(this.threadGroup_, runnable, name);
        return thread;
    }
}

