/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransportException;
import com.google.common.base.Charsets;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.meta.AbstractMetaClient;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.GetEdgeReq;
import com.vesoft.nebula.meta.GetEdgeResp;
import com.vesoft.nebula.meta.GetPartsAllocReq;
import com.vesoft.nebula.meta.GetPartsAllocResp;
import com.vesoft.nebula.meta.GetSpaceReq;
import com.vesoft.nebula.meta.GetSpaceResp;
import com.vesoft.nebula.meta.GetTagReq;
import com.vesoft.nebula.meta.GetTagResp;
import com.vesoft.nebula.meta.HostItem;
import com.vesoft.nebula.meta.HostStatus;
import com.vesoft.nebula.meta.IdName;
import com.vesoft.nebula.meta.ListEdgesReq;
import com.vesoft.nebula.meta.ListEdgesResp;
import com.vesoft.nebula.meta.ListHostType;
import com.vesoft.nebula.meta.ListHostsReq;
import com.vesoft.nebula.meta.ListHostsResp;
import com.vesoft.nebula.meta.ListSpacesReq;
import com.vesoft.nebula.meta.ListSpacesResp;
import com.vesoft.nebula.meta.ListTagsReq;
import com.vesoft.nebula.meta.ListTagsResp;
import com.vesoft.nebula.meta.MetaService;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.meta.SpaceItem;
import com.vesoft.nebula.meta.TagItem;
import com.vesoft.nebula.meta.VerifyClientVersionReq;
import com.vesoft.nebula.meta.VerifyClientVersionResp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClient
extends AbstractMetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClient.class);
    public static final int LATEST_SCHEMA_VERSION = -1;
    private static final int DEFAULT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_CONNECTION_RETRY_SIZE = 3;
    private static final int DEFAULT_EXECUTION_RETRY_SIZE = 3;
    private static final int RETRY_TIMES = 1;
    private MetaService.Client client;
    private final List<HostAddress> addresses;

    public MetaClient(String host, int port) {
        this(new HostAddress(host, port));
    }

    public MetaClient(HostAddress address) {
        this(Arrays.asList(address), 3, 3);
    }

    public MetaClient(List<HostAddress> addresses) {
        this(addresses, 3, 3);
    }

    public MetaClient(List<HostAddress> addresses, int connectionRetry, int executionRetry) {
        this(addresses, 1000, connectionRetry, executionRetry);
    }

    public MetaClient(List<HostAddress> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
        this.addresses = addresses;
    }

    public void connect() throws TException, ClientServerIncompatibleException {
        this.doConnect();
    }

    private void doConnect() throws TTransportException, ClientServerIncompatibleException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(this.addresses.size());
        HostAddress address = this.addresses.get(position);
        this.getClient(address.getHost(), address.getPort());
    }

    private void getClient(String host, int port) throws TTransportException, ClientServerIncompatibleException {
        this.transport = new TSocket(host, port, this.timeout, this.timeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        this.client = new MetaService.Client(this.protocol);
        VerifyClientVersionResp resp = this.client.verifyClientVersion(new VerifyClientVersionReq());
        if (resp.getCode() != ErrorCode.SUCCEEDED) {
            this.client.getInputProtocol().getTransport().close();
            throw new ClientServerIncompatibleException(new String(resp.getError_msg(), Charsets.UTF_8));
        }
    }

    private void freshClient(HostAddr leader) throws TTransportException {
        this.close();
        try {
            this.getClient(leader.getHost(), leader.getPort());
        }
        catch (ClientServerIncompatibleException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public synchronized List<IdName> getSpaces() throws TException, ExecuteFailedException {
        int retry = 1;
        ListSpacesReq request = new ListSpacesReq();
        ListSpacesResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.listSpaces(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("List Spaces Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getSpaces();
        }
        LOGGER.error("Get Spaces execute failed, errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get Spaces execute failed, errorCode: " + response.getCode());
    }

    public synchronized SpaceItem getSpace(String spaceName) throws TException, ExecuteFailedException {
        int retry = 1;
        GetSpaceReq request = new GetSpaceReq();
        request.setSpace_name(spaceName.getBytes());
        GetSpaceResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.getSpace(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Space Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getItem();
        }
        LOGGER.error("Get Space execute failed, errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get Space execute failed, errorCode: " + response.getCode());
    }

    public synchronized List<TagItem> getTags(String spaceName) throws TException, ExecuteFailedException {
        int retry = 1;
        int spaceID = this.getSpace((String)spaceName).space_id;
        ListTagsReq request = new ListTagsReq(spaceID);
        ListTagsResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.listTags(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getTags();
        }
        LOGGER.error("Get tags execute failed, errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get Tags execute failed, errorCode: " + response.getCode());
    }

    public synchronized Schema getTag(String spaceName, String tagName) throws TException, ExecuteFailedException {
        int retry = 1;
        GetTagReq request = new GetTagReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        request.setTag_name(tagName.getBytes());
        request.setVersion(-1L);
        GetTagResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.getTag(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getSchema();
        }
        LOGGER.error("Get tag execute failed, errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get tag execute failed, errorCode: " + response.getCode());
    }

    public synchronized List<EdgeItem> getEdges(String spaceName) throws TException, ExecuteFailedException {
        int retry = 1;
        int spaceID = this.getSpace(spaceName).getSpace_id();
        ListEdgesReq request = new ListEdgesReq(spaceID);
        ListEdgesResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.listEdges(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Edge Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getEdges();
        }
        LOGGER.error("Get edges execute failed: errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get execute edges failed, errorCode: " + response.getCode());
    }

    public synchronized Schema getEdge(String spaceName, String edgeName) throws TException, ExecuteFailedException {
        int retry = 1;
        GetEdgeReq request = new GetEdgeReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        request.setEdge_name(edgeName.getBytes());
        request.setVersion(-1L);
        GetEdgeResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.getEdge(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Edge Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getSchema();
        }
        LOGGER.error("Get Edge execute failed, errorCode: " + response.getCode());
        throw new ExecuteFailedException("Get Edge execute failed, errorCode: " + response.getCode());
    }

    public synchronized Map<Integer, List<HostAddr>> getPartsAlloc(String spaceName) throws ExecuteFailedException, TException {
        int retry = 1;
        GetPartsAllocReq request = new GetPartsAllocReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        GetPartsAllocResp response = null;
        try {
            while (retry-- >= 0 && (response = this.client.getPartsAlloc(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(response.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Parts Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == ErrorCode.SUCCEEDED) {
            return response.getParts();
        }
        LOGGER.error("Get Parts execute failed, errorCode" + response.getCode());
        throw new ExecuteFailedException("Get Parts execute failed, errorCode" + response.getCode());
    }

    public synchronized Set<HostAddr> listHosts() {
        int retry = 1;
        ListHostsReq request = new ListHostsReq();
        request.setType(ListHostType.STORAGE);
        ListHostsResp resp = null;
        try {
            while (retry-- >= 0 && (resp = this.client.listHosts(request)).getCode() == ErrorCode.E_LEADER_CHANGED) {
                this.freshClient(resp.getLeader());
            }
        }
        catch (TException e) {
            LOGGER.error("listHosts error", (Throwable)e);
            return null;
        }
        if (resp.getCode() != ErrorCode.SUCCEEDED) {
            LOGGER.error("listHosts execute failed, errorCode: " + resp.getCode());
            return null;
        }
        HashSet<HostAddr> hostAddrs = new HashSet<HostAddr>();
        for (HostItem hostItem : resp.hosts) {
            if (hostItem.getStatus().getValue() != HostStatus.ONLINE.getValue()) continue;
            hostAddrs.add(hostItem.getHostAddr());
        }
        return hostAddrs;
    }
}

