/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TJSONProtocolBase;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import java.util.Map;
import java.util.Stack;

public class TCompactJSONProtocol
extends TJSONProtocolBase {
    private Stack<Map<Integer, FieldMetaData>> structStack_ = new Stack();

    public TCompactJSONProtocol(TTransport trans) {
        super(trans);
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.writeJSONObjectStart();
    }

    @Override
    public void writeStructEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.writeString(field.name);
    }

    @Override
    public void writeFieldEnd() throws TException {
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.writeJSONObjectStart();
    }

    @Override
    public void writeMapEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.writeJSONArrayStart();
    }

    @Override
    public void writeListEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.writeJSONArrayStart();
    }

    @Override
    public void writeSetEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeBool(boolean b) throws TException {
        this.writeJSONInteger(b ? 1L : 0L);
    }

    @Override
    public TStruct readStructBegin(Map<Integer, FieldMetaData> metaDataMap) throws TException {
        this.readJSONObjectStart();
        this.structStack_.push(metaDataMap);
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() throws TException {
        this.structStack_.pop();
        this.readJSONObjectEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        if (this.reader_.peek() == RBRACE[0]) {
            return new TField("", 0, 0);
        }
        String name = this.readString();
        for (Map.Entry<Integer, FieldMetaData> entry : this.structStack_.peek().entrySet()) {
            if (!entry.getValue().fieldName.equals(name)) continue;
            return new TField(name, entry.getValue().valueMetaData.type, entry.getKey().shortValue());
        }
        return new TField(name, TCompactJSONProtocol.getTypeIDForPeekedByte(this.context_.peekNextValue()), 0);
    }

    @Override
    public void readFieldEnd() throws TException {
    }

    @Override
    public TMap readMapBegin() throws TException {
        this.readJSONObjectStart();
        return new TMap(11, 0, -1);
    }

    @Override
    public boolean peekMap() throws TException {
        return this.reader_.peek() != RBRACE[0];
    }

    @Override
    public void readMapEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        this.readJSONArrayStart();
        return new TList(TCompactJSONProtocol.getTypeIDForPeekedByte(this.reader_.peek()), -1);
    }

    @Override
    public boolean peekList() throws TException {
        return this.reader_.peek() != RBRACKET[0];
    }

    @Override
    public void readListEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        this.readJSONArrayStart();
        return new TSet(TCompactJSONProtocol.getTypeIDForPeekedByte(this.reader_.peek()), -1);
    }

    @Override
    public boolean peekSet() throws TException {
        return this.reader_.peek() != RBRACKET[0];
    }

    @Override
    public void readSetEnd() throws TException {
        this.readJSONArrayEnd();
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TCompactJSONProtocol(trans);
        }
    }
}

