/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.storage.ScanType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IndexColumnHint
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("IndexColumnHint");
    private static final TField COLUMN_NAME_FIELD_DESC = new TField("column_name", 11, 1);
    private static final TField SCAN_TYPE_FIELD_DESC = new TField("scan_type", 8, 2);
    private static final TField BEGIN_VALUE_FIELD_DESC = new TField("begin_value", 12, 3);
    private static final TField END_VALUE_FIELD_DESC = new TField("end_value", 12, 4);
    public byte[] column_name;
    public ScanType scan_type;
    public Value begin_value;
    public Value end_value;
    public static final int COLUMN_NAME = 1;
    public static final int SCAN_TYPE = 2;
    public static final int BEGIN_VALUE = 3;
    public static final int END_VALUE = 4;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public IndexColumnHint() {
    }

    public IndexColumnHint(byte[] column_name, ScanType scan_type, Value begin_value, Value end_value) {
        this();
        this.column_name = column_name;
        this.scan_type = scan_type;
        this.begin_value = begin_value;
        this.end_value = end_value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IndexColumnHint(IndexColumnHint other) {
        if (other.isSetColumn_name()) {
            this.column_name = TBaseHelper.deepCopy(other.column_name);
        }
        if (other.isSetScan_type()) {
            this.scan_type = TBaseHelper.deepCopy(other.scan_type);
        }
        if (other.isSetBegin_value()) {
            this.begin_value = TBaseHelper.deepCopy(other.begin_value);
        }
        if (other.isSetEnd_value()) {
            this.end_value = TBaseHelper.deepCopy(other.end_value);
        }
    }

    @Override
    public IndexColumnHint deepCopy() {
        return new IndexColumnHint(this);
    }

    public byte[] getColumn_name() {
        return this.column_name;
    }

    public IndexColumnHint setColumn_name(byte[] column_name) {
        this.column_name = column_name;
        return this;
    }

    public void unsetColumn_name() {
        this.column_name = null;
    }

    public boolean isSetColumn_name() {
        return this.column_name != null;
    }

    public void setColumn_nameIsSet(boolean __value) {
        if (!__value) {
            this.column_name = null;
        }
    }

    public ScanType getScan_type() {
        return this.scan_type;
    }

    public IndexColumnHint setScan_type(ScanType scan_type) {
        this.scan_type = scan_type;
        return this;
    }

    public void unsetScan_type() {
        this.scan_type = null;
    }

    public boolean isSetScan_type() {
        return this.scan_type != null;
    }

    public void setScan_typeIsSet(boolean __value) {
        if (!__value) {
            this.scan_type = null;
        }
    }

    public Value getBegin_value() {
        return this.begin_value;
    }

    public IndexColumnHint setBegin_value(Value begin_value) {
        this.begin_value = begin_value;
        return this;
    }

    public void unsetBegin_value() {
        this.begin_value = null;
    }

    public boolean isSetBegin_value() {
        return this.begin_value != null;
    }

    public void setBegin_valueIsSet(boolean __value) {
        if (!__value) {
            this.begin_value = null;
        }
    }

    public Value getEnd_value() {
        return this.end_value;
    }

    public IndexColumnHint setEnd_value(Value end_value) {
        this.end_value = end_value;
        return this;
    }

    public void unsetEnd_value() {
        this.end_value = null;
    }

    public boolean isSetEnd_value() {
        return this.end_value != null;
    }

    public void setEnd_valueIsSet(boolean __value) {
        if (!__value) {
            this.end_value = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetColumn_name();
                    break;
                }
                this.setColumn_name((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetScan_type();
                    break;
                }
                this.setScan_type((ScanType)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetBegin_value();
                    break;
                }
                this.setBegin_value((Value)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetEnd_value();
                    break;
                }
                this.setEnd_value((Value)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getColumn_name();
            }
            case 2: {
                return this.getScan_type();
            }
            case 3: {
                return this.getBegin_value();
            }
            case 4: {
                return this.getEnd_value();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof IndexColumnHint)) {
            return false;
        }
        IndexColumnHint that = (IndexColumnHint)_that;
        if (!TBaseHelper.equalsSlow(this.isSetColumn_name(), that.isSetColumn_name(), this.column_name, that.column_name)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetScan_type(), that.isSetScan_type(), this.scan_type, that.scan_type)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetBegin_value(), that.isSetBegin_value(), this.begin_value, that.begin_value)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetEnd_value(), that.isSetEnd_value(), this.end_value, that.end_value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.column_name, this.scan_type, this.begin_value, this.end_value});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.column_name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.scan_type = ScanType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 12) {
                        this.begin_value = new Value();
                        this.begin_value.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 12) {
                        this.end_value = new Value();
                        this.end_value.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.column_name != null) {
            oprot.writeFieldBegin(COLUMN_NAME_FIELD_DESC);
            oprot.writeBinary(this.column_name);
            oprot.writeFieldEnd();
        }
        if (this.scan_type != null) {
            oprot.writeFieldBegin(SCAN_TYPE_FIELD_DESC);
            oprot.writeI32(this.scan_type == null ? 0 : this.scan_type.getValue());
            oprot.writeFieldEnd();
        }
        if (this.begin_value != null) {
            oprot.writeFieldBegin(BEGIN_VALUE_FIELD_DESC);
            this.begin_value.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.end_value != null) {
            oprot.writeFieldBegin(END_VALUE_FIELD_DESC);
            this.end_value.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("IndexColumnHint");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("column_name");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getColumn_name() == null) {
            sb.append("null");
        } else {
            int __column_name_size = Math.min(this.getColumn_name().length, 128);
            for (int i = 0; i < __column_name_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getColumn_name()[i]).length() > 1 ? Integer.toHexString(this.getColumn_name()[i]).substring(Integer.toHexString(this.getColumn_name()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getColumn_name()[i]).toUpperCase());
            }
            if (this.getColumn_name().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("scan_type");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getScan_type() == null) {
            sb.append("null");
        } else {
            String scan_type_name;
            String string = scan_type_name = this.getScan_type() == null ? "null" : this.getScan_type().name();
            if (scan_type_name != null) {
                sb.append(scan_type_name);
                sb.append(" (");
            }
            sb.append(this.getScan_type());
            if (scan_type_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("begin_value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getBegin_value() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getBegin_value(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("end_value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getEnd_value() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getEnd_value(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("column_name", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("scan_type", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("begin_value", 3, new StructMetaData(12, Value.class)));
        tmpMetaDataMap.put(4, new FieldMetaData("end_value", 3, new StructMetaData(12, Value.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(IndexColumnHint.class, metaDataMap);
    }

    public static class Builder {
        private byte[] column_name;
        private ScanType scan_type;
        private Value begin_value;
        private Value end_value;

        public Builder setColumn_name(byte[] column_name) {
            this.column_name = column_name;
            return this;
        }

        public Builder setScan_type(ScanType scan_type) {
            this.scan_type = scan_type;
            return this;
        }

        public Builder setBegin_value(Value begin_value) {
            this.begin_value = begin_value;
            return this;
        }

        public Builder setEnd_value(Value end_value) {
            this.end_value = end_value;
            return this;
        }

        public IndexColumnHint build() {
            IndexColumnHint result = new IndexColumnHint();
            result.setColumn_name(this.column_name);
            result.setScan_type(this.scan_type);
            result.setBegin_value(this.begin_value);
            result.setEnd_value(this.end_value);
            return result;
        }
    }
}

