/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.scan;

import com.facebook.thrift.TException;
import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.meta.MetaManager;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StorageConnPool;
import com.vesoft.nebula.client.storage.data.ScanStatus;
import com.vesoft.nebula.client.storage.scan.PartScanInfo;
import com.vesoft.nebula.client.storage.scan.PartScanQueue;
import com.vesoft.nebula.client.storage.scan.ScanResultIterator;
import com.vesoft.nebula.client.storage.scan.ScanVertexResult;
import com.vesoft.nebula.storage.PartitionResult;
import com.vesoft.nebula.storage.ScanVertexRequest;
import com.vesoft.nebula.storage.ScanVertexResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanVertexResultIterator
extends ScanResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanVertexResultIterator.class);
    private final ScanVertexRequest request;
    private ExecutorService threadPool = null;

    private ScanVertexResultIterator(MetaManager metaManager, StorageConnPool pool, Set<PartScanInfo> partScanInfoList, List<HostAddress> addresses, ScanVertexRequest request, String spaceName, String labelName, boolean partSuccess) {
        super(metaManager, pool, new PartScanQueue(partScanInfoList), addresses, spaceName, labelName, partSuccess);
        this.request = request;
    }

    public ScanVertexResult next() throws Exception {
        if (!this.hasNext()) {
            throw new IllegalAccessException("iterator has no more data");
        }
        List<DataSet> results = Collections.synchronizedList(new ArrayList(this.addresses.size()));
        List<Exception> exceptions = Collections.synchronizedList(new ArrayList(this.addresses.size()));
        CountDownLatch countDownLatch = new CountDownLatch(this.addresses.size());
        AtomicInteger existSuccess = new AtomicInteger(0);
        this.threadPool = Executors.newFixedThreadPool(this.addresses.size());
        for (HostAddress addr : this.addresses) {
            this.threadPool.submit(() -> {
                ScanVertexResponse response;
                GraphStorageConnection connection;
                ScanVertexRequest partRequest = new ScanVertexRequest(this.request);
                PartScanInfo partInfo = this.partScanQueue.getPart(addr);
                if (partInfo == null) {
                    countDownLatch.countDown();
                    existSuccess.addAndGet(1);
                    return;
                }
                try {
                    connection = this.pool.getStorageConnection(addr);
                }
                catch (Exception e) {
                    LOGGER.error("get storage client error, ", (Throwable)e);
                    exceptions.add(e);
                    countDownLatch.countDown();
                    return;
                }
                partRequest.setPart_id(partInfo.getPart());
                partRequest.setCursor(partInfo.getCursor());
                try {
                    response = connection.scanVertex(partRequest);
                }
                catch (TException e) {
                    LOGGER.error(String.format("Scan vertex failed for %s", e.getMessage()), (Throwable)e);
                    exceptions.add(e);
                    this.partScanQueue.dropPart(partInfo);
                    countDownLatch.countDown();
                    return;
                }
                if (response == null) {
                    this.handleNullResponse(partInfo, exceptions);
                    countDownLatch.countDown();
                    return;
                }
                if (this.isSuccessful(response)) {
                    this.handleSucceedResult(existSuccess, response, partInfo);
                    results.add(response.getVertex_data());
                }
                if (response.getResult() != null) {
                    this.handleFailedResult(response, partInfo, exceptions);
                } else {
                    this.handleNullResult(partInfo, exceptions);
                }
                this.pool.release(addr, connection);
                countDownLatch.countDown();
            });
        }
        try {
            countDownLatch.await();
            this.threadPool.shutdown();
        }
        catch (InterruptedException interruptedE) {
            LOGGER.error("scan interrupted:", (Throwable)interruptedE);
            throw interruptedE;
        }
        if (this.partSuccess) {
            boolean bl = this.hasNext = this.partScanQueue.size() > 0;
            if (existSuccess.get() == 0) {
                this.throwExceptions(exceptions);
            }
            ScanStatus status = exceptions.size() > 0 ? ScanStatus.PART_SUCCESS : ScanStatus.ALL_SUCCESS;
            return new ScanVertexResult(results, status);
        }
        boolean bl = this.hasNext = this.partScanQueue.size() > 0 && exceptions.isEmpty();
        if (!exceptions.isEmpty()) {
            this.throwExceptions(exceptions);
        }
        boolean success = existSuccess.get() == this.addresses.size();
        List<DataSet> finalResults = success ? results : null;
        return new ScanVertexResult(finalResults, ScanStatus.ALL_SUCCESS);
    }

    private boolean isSuccessful(ScanVertexResponse response) {
        return response != null && response.result.failed_parts.size() <= 0;
    }

    private void handleSucceedResult(AtomicInteger existSuccess, ScanVertexResponse response, PartScanInfo partInfo) {
        existSuccess.addAndGet(1);
        if (!response.has_next) {
            this.partScanQueue.dropPart(partInfo);
        } else {
            partInfo.setCursor(response.getNext_cursor());
        }
    }

    private void handleFailedResult(ScanVertexResponse response, PartScanInfo partInfo, List<Exception> exceptions) {
        for (PartitionResult partResult : response.getResult().getFailed_parts()) {
            if (partResult.code == -11) {
                this.freshLeader(this.spaceName, partInfo.getPart(), partResult.getLeader());
                partInfo.setLeader(this.getLeader(partResult.getLeader()));
                continue;
            }
            int code = partResult.getCode();
            LOGGER.error(String.format("part scan failed, error code=%d", code));
            this.partScanQueue.dropPart(partInfo);
            exceptions.add(new Exception(String.format("part scan, error code=%d", code)));
        }
    }

    public static class ScanVertexResultBuilder {
        MetaManager metaManager;
        StorageConnPool pool;
        Set<PartScanInfo> partScanInfoList;
        List<HostAddress> addresses;
        ScanVertexRequest request;
        String spaceName;
        String tagName;
        boolean partSuccess = false;

        public ScanVertexResultBuilder withMetaClient(MetaManager metaManager) {
            this.metaManager = metaManager;
            return this;
        }

        public ScanVertexResultBuilder withPool(StorageConnPool pool) {
            this.pool = pool;
            return this;
        }

        public ScanVertexResultBuilder withPartScanInfo(Set<PartScanInfo> partScanInfoList) {
            this.partScanInfoList = partScanInfoList;
            return this;
        }

        public ScanVertexResultBuilder withAddresses(List<HostAddress> addresses) {
            this.addresses = addresses;
            return this;
        }

        public ScanVertexResultBuilder withRequest(ScanVertexRequest request) {
            this.request = request;
            return this;
        }

        public ScanVertexResultBuilder withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public ScanVertexResultBuilder withTagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public ScanVertexResultBuilder withPartSuccess(boolean partSuccess) {
            this.partSuccess = partSuccess;
            return this;
        }

        public ScanVertexResultIterator build() {
            return new ScanVertexResultIterator(this.metaManager, this.pool, this.partScanInfoList, this.addresses, this.request, this.spaceName, this.tagName, this.partSuccess);
        }
    }
}

