/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.facebook.thrift.TException;
import com.google.common.collect.Maps;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.meta.MetaCache;
import com.vesoft.nebula.client.meta.MetaClient;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.IdName;
import com.vesoft.nebula.meta.SpaceItem;
import com.vesoft.nebula.meta.TagItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaManager
implements MetaCache {
    private Map<String, SpaceInfo> spacesInfo = new HashMap<String, SpaceInfo>();
    private Map<String, Map<Integer, HostAddr>> partLeaders = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaManager.class);
    private static MetaClient metaClient;
    private static MetaManager metaManager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private MetaManager() {
    }

    private void init(List<HostAddress> address) throws TException {
        metaClient = new MetaClient(address);
        metaClient.connect();
        this.fillMetaInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaManager getMetaManager(List<HostAddress> address) throws TException {
        if (metaManager != null) return metaManager;
        Class<MetaManager> clazz = MetaManager.class;
        synchronized (MetaManager.class) {
            if (metaManager != null) return metaManager;
            metaManager = new MetaManager();
            metaManager.init(address);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metaManager;
        }
    }

    public void close() {
        metaManager = null;
        metaClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMetaInfo() {
        try {
            HashMap<String, SpaceInfo> tempSpacesInfo = new HashMap<String, SpaceInfo>();
            List<IdName> spaces = metaClient.getSpaces();
            for (IdName space : spaces) {
                SpaceInfo spaceInfo = new SpaceInfo();
                String spaceName = new String(space.name);
                SpaceItem spaceItem = metaClient.getSpace(spaceName);
                spaceInfo.spaceItem = spaceItem;
                List<TagItem> tags = metaClient.getTags(spaceName);
                for (TagItem tag : tags) {
                    String tagName = new String(tag.tag_name);
                    if (spaceInfo.tagItems.containsKey(tagName) && ((TagItem)spaceInfo.tagItems.get(tagName)).getVersion() >= tag.getVersion()) continue;
                    spaceInfo.tagItems.put(tagName, tag);
                    spaceInfo.tagIdNames.put(tag.tag_id, tagName);
                }
                List<EdgeItem> edges = metaClient.getEdges(spaceName);
                for (EdgeItem edge : edges) {
                    String edgeName = new String(edge.edge_name);
                    if (spaceInfo.edgeItems.containsKey(edgeName) && ((EdgeItem)spaceInfo.edgeItems.get(edgeName)).getVersion() >= edge.getVersion()) continue;
                    spaceInfo.edgeItems.put(edgeName, edge);
                    spaceInfo.edgeTypeNames.put(edge.edge_type, edgeName);
                }
                spaceInfo.partsAlloc = MetaManager.metaClient.getPartsAlloc(spaceName);
                tempSpacesInfo.put(spaceName, spaceInfo);
            }
            try {
                this.lock.writeLock().lock();
                this.spacesInfo = tempSpacesInfo;
                if (this.partLeaders == null) {
                    this.partLeaders = new HashMap<String, Map<Integer, HostAddr>>();
                }
                for (String spaceName : this.spacesInfo.keySet()) {
                    if (this.partLeaders.containsKey(spaceName)) continue;
                    this.partLeaders.put(spaceName, Maps.newConcurrentMap());
                    Iterator iterator = this.spacesInfo.get(spaceName).partsAlloc.keySet().iterator();
                    while (iterator.hasNext()) {
                        int partId = (Integer)iterator.next();
                        if (((List)this.spacesInfo.get(spaceName).partsAlloc.get(partId)).size() < 1) {
                            LOGGER.error("space {} part {} has not allocation host.", (Object)spaceName, (Object)partId);
                            continue;
                        }
                        this.partLeaders.get(spaceName).put(partId, (HostAddr)((List)this.spacesInfo.get(spaceName).partsAlloc.get(partId)).get(0));
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (TException | ExecuteFailedException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public int getSpaceId(String spaceName) throws IllegalArgumentException {
        return this.getSpace((String)spaceName).space_id;
    }

    @Override
    public SpaceItem getSpace(String spaceName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("space:" + spaceName + " does not exist.");
            }
            SpaceItem spaceItem = this.spacesInfo.get(spaceName).spaceItem;
            return spaceItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getTagId(String spaceName, String tagName) throws IllegalArgumentException {
        return this.getTag((String)spaceName, (String)tagName).tag_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagItem getTag(String spaceName, String tagName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName) || !this.spacesInfo.get(spaceName).tagItems.containsKey(tagName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.spacesInfo.get(spaceName).tagItems.containsKey(tagName)) {
                throw new IllegalArgumentException("Tag:" + tagName + " does not exist.");
            }
            TagItem tagItem = (TagItem)this.spacesInfo.get(spaceName).tagItems.get(tagName);
            return tagItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getEdgeType(String spaceName, String edgeName) throws IllegalArgumentException {
        return this.getEdge((String)spaceName, (String)edgeName).edge_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeItem getEdge(String spaceName, String edgeName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName) || !this.spacesInfo.get(spaceName).edgeItems.containsKey(edgeName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.spacesInfo.get(spaceName).edgeItems.containsKey(edgeName)) {
                throw new IllegalArgumentException("Edge:" + edgeName + " does not exist.");
            }
            EdgeItem edgeItem = (EdgeItem)this.spacesInfo.get(spaceName).edgeItems.get(edgeName);
            return edgeItem;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddr getLeader(String spaceName, int part) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (this.partLeaders == null) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.get(spaceName).containsKey(part)) {
                throw new IllegalArgumentException("PartId:" + part + " does not exist.");
            }
            HostAddr hostAddr = this.partLeaders.get(spaceName).get(part);
            return hostAddr;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Integer> getSpaceParts(String spaceName) throws IllegalArgumentException {
        return new ArrayList<Integer>(this.getPartsAlloc(spaceName).keySet());
    }

    @Override
    public Map<Integer, List<HostAddr>> getPartsAlloc(String spaceName) throws IllegalArgumentException {
        if (!this.spacesInfo.containsKey(spaceName)) {
            this.fillMetaInfo();
        }
        try {
            this.lock.readLock().lock();
            if (!this.spacesInfo.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            Map map = this.spacesInfo.get(spaceName).partsAlloc;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeader(String spaceName, int part, HostAddr newLeader) throws IllegalArgumentException {
        try {
            this.lock.writeLock().lock();
            if (this.partLeaders == null) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.containsKey(spaceName)) {
                throw new IllegalArgumentException("Space:" + spaceName + " does not exist.");
            }
            if (!this.partLeaders.get(spaceName).containsKey(part)) {
                throw new IllegalArgumentException("PartId:" + part + " does not exist.");
            }
            this.partLeaders.get(spaceName).put(part, newLeader);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<HostAddr> listHosts() {
        return metaClient.listHosts();
    }

    public int getConnectionRetry() {
        return metaClient.getConnectionRetry();
    }

    public int getTimeout() {
        return metaClient.getTimeout();
    }

    public int getExecutionRetry() {
        return metaClient.getExecutionRetry();
    }

    private class SpaceInfo {
        private SpaceItem spaceItem = null;
        private Map<String, TagItem> tagItems = new HashMap<String, TagItem>();
        private Map<Integer, String> tagIdNames = new HashMap<Integer, String>();
        private Map<String, EdgeItem> edgeItems = new HashMap<String, EdgeItem>();
        private Map<Integer, String> edgeTypeNames = new HashMap<Integer, String>();
        private Map<Integer, List<HostAddr>> partsAlloc = new HashMap<Integer, List<HostAddr>>();

        private SpaceInfo() {
        }
    }
}

