/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServerSocket
extends TServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TServerSocket.class.getName());
    private ServerSocket serverSocket_ = null;
    private int clientTimeout_ = 0;

    public TServerSocket(ServerSocket serverSocket) {
        this(serverSocket, 0);
    }

    public TServerSocket(ServerSocket serverSocket, int clientTimeout) {
        this.serverSocket_ = serverSocket;
        this.clientTimeout_ = clientTimeout;
    }

    public TServerSocket(int port) throws TTransportException {
        this(port, 0);
    }

    public TServerSocket(int port, int clientTimeout) throws TTransportException {
        this(new InetSocketAddress(port), clientTimeout);
    }

    public TServerSocket(int port, int clientTimeout, int backlog) throws TTransportException {
        this(new InetSocketAddress(port), clientTimeout, backlog);
    }

    public TServerSocket(InetSocketAddress bindAddr) throws TTransportException {
        this(bindAddr, 0, 0);
    }

    public TServerSocket(InetSocketAddress bindAddr, int clientTimeout) throws TTransportException {
        this(bindAddr, clientTimeout, 0);
    }

    public TServerSocket(InetSocketAddress bindAddr, int clientTimeout, int backlog) throws TTransportException {
        this.clientTimeout_ = clientTimeout;
        try {
            this.serverSocket_ = new ServerSocket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(bindAddr, backlog);
        }
        catch (IOException ioe) {
            this.serverSocket_ = null;
            throw new TTransportException("Could not create ServerSocket on address " + bindAddr.toString() + ".");
        }
    }

    @Override
    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException sx) {
                LOGGER.error("Could not set socket timeout.", (Throwable)sx);
            }
        }
    }

    @Override
    protected TTransport acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            Socket result = this.serverSocket_.accept();
            TSocket result2 = new TSocket(result);
            result2.setTimeout(this.clientTimeout_);
            return result2;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Could not close server socket.", (Throwable)iox);
            }
            this.serverSocket_ = null;
        }
    }

    @Override
    public void interrupt() {
        this.close();
    }
}

