/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Vertex
implements TBase,
Serializable,
Cloneable,
Comparable<Vertex> {
    private static final TStruct STRUCT_DESC = new TStruct("Vertex");
    private static final TField ID_FIELD_DESC = new TField("id", 10, 1);
    private static final TField TAGS_FIELD_DESC = new TField("tags", 15, 2);
    public long id;
    public List<Tag> tags;
    public static final int ID = 1;
    public static final int TAGS = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Vertex() {
    }

    public Vertex(long id, List<Tag> tags) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.tags = tags;
    }

    public Vertex(Vertex other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.id = TBaseHelper.deepCopy(other.id);
        if (other.isSetTags()) {
            this.tags = TBaseHelper.deepCopy(other.tags);
        }
    }

    @Override
    public Vertex deepCopy() {
        return new Vertex(this);
    }

    @Deprecated
    public Vertex clone() {
        return new Vertex(this);
    }

    public long getId() {
        return this.id;
    }

    public Vertex setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetId() {
        return this.__isset_bit_vector.get(0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Vertex setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public void unsetTags() {
        this.tags = null;
    }

    public boolean isSetTags() {
        return this.tags != null;
    }

    public void setTagsIsSet(boolean value) {
        if (!value) {
            this.tags = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTags();
                    break;
                }
                this.setTags((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Long(this.getId());
            }
            case 2: {
                return this.getTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetId();
            }
            case 2: {
                return this.isSetTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Vertex) {
            return this.equals((Vertex)that);
        }
        return false;
    }

    public boolean equals(Vertex that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.id, that.id)) {
                return false;
            }
        }
        boolean this_present_tags = this.isSetTags();
        boolean that_present_tags = that.isSetTags();
        if (this_present_tags || that_present_tags) {
            if (!this_present_tags || !that_present_tags) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.tags, that.tags)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_id = true;
        builder.append(present_id);
        if (present_id) {
            builder.append(this.id);
        }
        boolean present_tags = this.isSetTags();
        builder.append(present_tags);
        if (present_tags) {
            builder.append(this.tags);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(Vertex other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.id, other.id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTags()).compareTo(other.isSetTags());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.tags, other.tags);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 10) {
                        this.id = iprot.readI64();
                        this.setIdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list30 = iprot.readListBegin();
                        this.tags = new ArrayList<Tag>(Math.max(0, _list30.size));
                        int _i31 = 0;
                        while (_list30.size < 0 ? iprot.peekList() : _i31 < _list30.size) {
                            Tag _elem32 = new Tag();
                            _elem32.read(iprot);
                            this.tags.add(_elem32);
                            ++_i31;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(ID_FIELD_DESC);
        oprot.writeI64(this.id);
        oprot.writeFieldEnd();
        if (this.tags != null) {
            oprot.writeFieldBegin(TAGS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.tags.size()));
            for (Tag _iter33 : this.tags) {
                _iter33.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Vertex");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getId(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("tags");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getTags() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getTags(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(2, new FieldMetaData("tags", 3, new ListMetaData(15, new StructMetaData(12, Tag.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Vertex.class, metaDataMap);
    }
}

