/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Schema;
import com.vesoft.nebula.storage.ResponseCommon;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class QueryStatsResponse
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("QueryStatsResponse");
    private static final TField RESULT_FIELD_DESC = new TField("result", 12, 1);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 2);
    private static final TField DATA_FIELD_DESC = new TField("data", 11, 3);
    public ResponseCommon result;
    public Schema schema;
    public byte[] data;
    public static final int RESULT = 1;
    public static final int SCHEMA = 2;
    public static final int DATA = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public QueryStatsResponse() {
    }

    public QueryStatsResponse(ResponseCommon result) {
        this();
        this.result = result;
    }

    public QueryStatsResponse(ResponseCommon result, Schema schema, byte[] data) {
        this();
        this.result = result;
        this.schema = schema;
        this.data = data;
    }

    public QueryStatsResponse(QueryStatsResponse other) {
        if (other.isSetResult()) {
            this.result = TBaseHelper.deepCopy(other.result);
        }
        if (other.isSetSchema()) {
            this.schema = TBaseHelper.deepCopy(other.schema);
        }
        if (other.isSetData()) {
            this.data = TBaseHelper.deepCopy(other.data);
        }
    }

    @Override
    public QueryStatsResponse deepCopy() {
        return new QueryStatsResponse(this);
    }

    @Deprecated
    public QueryStatsResponse clone() {
        return new QueryStatsResponse(this);
    }

    public ResponseCommon getResult() {
        return this.result;
    }

    public QueryStatsResponse setResult(ResponseCommon result) {
        this.result = result;
        return this;
    }

    public void unsetResult() {
        this.result = null;
    }

    public boolean isSetResult() {
        return this.result != null;
    }

    public void setResultIsSet(boolean value) {
        if (!value) {
            this.result = null;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public QueryStatsResponse setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public QueryStatsResponse setData(byte[] data) {
        this.data = data;
        return this;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetResult();
                    break;
                }
                this.setResult((ResponseCommon)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((Schema)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getResult();
            }
            case 2: {
                return this.getSchema();
            }
            case 3: {
                return this.getData();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetResult();
            }
            case 2: {
                return this.isSetSchema();
            }
            case 3: {
                return this.isSetData();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof QueryStatsResponse) {
            return this.equals((QueryStatsResponse)that);
        }
        return false;
    }

    public boolean equals(QueryStatsResponse that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_result = this.isSetResult();
        boolean that_present_result = that.isSetResult();
        if (this_present_result || that_present_result) {
            if (!this_present_result || !that_present_result) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.result, that.result)) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.schema, that.schema)) {
                return false;
            }
        }
        boolean this_present_data = this.isSetData();
        boolean that_present_data = that.isSetData();
        if (this_present_data || that_present_data) {
            if (!this_present_data || !that_present_data) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.data, that.data)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_result = this.isSetResult();
        builder.append(present_result);
        if (present_result) {
            builder.append((Object)this.result);
        }
        boolean present_schema = this.isSetSchema();
        builder.append(present_schema);
        if (present_schema) {
            builder.append((Object)this.schema);
        }
        boolean present_data = this.isSetData();
        builder.append(present_data);
        if (present_data) {
            builder.append(this.data);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.result = new ResponseCommon();
                        this.result.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.schema = new Schema();
                        this.schema.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.data = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.result != null) {
            oprot.writeFieldBegin(RESULT_FIELD_DESC);
            this.result.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.schema != null && this.isSetSchema()) {
            oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
            this.schema.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.data != null && this.isSetData()) {
            oprot.writeFieldBegin(DATA_FIELD_DESC);
            oprot.writeBinary(this.data);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("QueryStatsResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("result");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getResult() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getResult(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetSchema()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("schema");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getSchema() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getSchema(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetData()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("data");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getData() == null) {
                sb.append("null");
            } else {
                int __data_size = Math.min(this.getData().length, 128);
                for (int i = 0; i < __data_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getData()[i]).length() > 1 ? Integer.toHexString(this.getData()[i]).substring(Integer.toHexString(this.getData()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getData()[i]).toUpperCase());
                }
                if (this.getData().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.result == null) {
            throw new TProtocolException(6, "Required field 'result' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("result", 1, new StructMetaData(12, ResponseCommon.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("schema", 2, new StructMetaData(12, Schema.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("data", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(QueryStatsResponse.class, metaDataMap);
    }
}

