/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.TUnion;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.graph.Date;
import com.vesoft.nebula.graph.DateTime;
import com.vesoft.nebula.graph.YearMonth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ColumnValue
extends TUnion<ColumnValue>
implements Comparable<ColumnValue> {
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final TStruct STRUCT_DESC = new TStruct("ColumnValue");
    private static final TField BOOL_VAL_FIELD_DESC = new TField("bool_val", 2, 1);
    private static final TField INTEGER_FIELD_DESC = new TField("integer", 10, 2);
    private static final TField ID_FIELD_DESC = new TField("id", 10, 3);
    private static final TField SINGLE_PRECISION_FIELD_DESC = new TField("single_precision", 19, 4);
    private static final TField DOUBLE_PRECISION_FIELD_DESC = new TField("double_precision", 4, 5);
    private static final TField STR_FIELD_DESC = new TField("str", 11, 6);
    private static final TField TIMESTAMP_FIELD_DESC = new TField("timestamp", 10, 7);
    private static final TField YEAR_FIELD_DESC = new TField("year", 6, 8);
    private static final TField MONTH_FIELD_DESC = new TField("month", 12, 9);
    private static final TField DATE_FIELD_DESC = new TField("date", 12, 10);
    private static final TField DATETIME_FIELD_DESC = new TField("datetime", 12, 11);
    public static final int BOOL_VAL = 1;
    public static final int INTEGER = 2;
    public static final int ID = 3;
    public static final int SINGLE_PRECISION = 4;
    public static final int DOUBLE_PRECISION = 5;
    public static final int STR = 6;
    public static final int TIMESTAMP = 7;
    public static final int YEAR = 8;
    public static final int MONTH = 9;
    public static final int DATE = 10;
    public static final int DATETIME = 11;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ColumnValue() {
    }

    public ColumnValue(int setField, Object value) {
        super(setField, value);
    }

    public ColumnValue(ColumnValue other) {
        super(other);
    }

    @Override
    public ColumnValue deepCopy() {
        return new ColumnValue(this);
    }

    public static ColumnValue bool_val(boolean value) {
        ColumnValue x = new ColumnValue();
        x.setBool_val(value);
        return x;
    }

    public static ColumnValue integer(long value) {
        ColumnValue x = new ColumnValue();
        x.setInteger(value);
        return x;
    }

    public static ColumnValue id(long value) {
        ColumnValue x = new ColumnValue();
        x.setId(value);
        return x;
    }

    public static ColumnValue single_precision(float value) {
        ColumnValue x = new ColumnValue();
        x.setSingle_precision(value);
        return x;
    }

    public static ColumnValue double_precision(double value) {
        ColumnValue x = new ColumnValue();
        x.setDouble_precision(value);
        return x;
    }

    public static ColumnValue str(byte[] value) {
        ColumnValue x = new ColumnValue();
        x.setStr(value);
        return x;
    }

    public static ColumnValue timestamp(long value) {
        ColumnValue x = new ColumnValue();
        x.setTimestamp(value);
        return x;
    }

    public static ColumnValue year(short value) {
        ColumnValue x = new ColumnValue();
        x.setYear(value);
        return x;
    }

    public static ColumnValue month(YearMonth value) {
        ColumnValue x = new ColumnValue();
        x.setMonth(value);
        return x;
    }

    public static ColumnValue date(Date value) {
        ColumnValue x = new ColumnValue();
        x.setDate(value);
        return x;
    }

    public static ColumnValue datetime(DateTime value) {
        ColumnValue x = new ColumnValue();
        x.setDatetime(value);
        return x;
    }

    @Override
    protected void checkType(short setField, Object value) throws ClassCastException {
        switch (setField) {
            case 1: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type Boolean for field 'bool_val', but got " + value.getClass().getSimpleName());
            }
            case 2: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'integer', but got " + value.getClass().getSimpleName());
            }
            case 3: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'id', but got " + value.getClass().getSimpleName());
            }
            case 4: {
                if (value instanceof Float) break;
                throw new ClassCastException("Was expecting value of type Float for field 'single_precision', but got " + value.getClass().getSimpleName());
            }
            case 5: {
                if (value instanceof Double) break;
                throw new ClassCastException("Was expecting value of type Double for field 'double_precision', but got " + value.getClass().getSimpleName());
            }
            case 6: {
                if (value instanceof byte[]) break;
                throw new ClassCastException("Was expecting value of type byte[] for field 'str', but got " + value.getClass().getSimpleName());
            }
            case 7: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'timestamp', but got " + value.getClass().getSimpleName());
            }
            case 8: {
                if (value instanceof Short) break;
                throw new ClassCastException("Was expecting value of type Short for field 'year', but got " + value.getClass().getSimpleName());
            }
            case 9: {
                if (value instanceof YearMonth) break;
                throw new ClassCastException("Was expecting value of type YearMonth for field 'month', but got " + value.getClass().getSimpleName());
            }
            case 10: {
                if (value instanceof Date) break;
                throw new ClassCastException("Was expecting value of type Date for field 'date', but got " + value.getClass().getSimpleName());
            }
            case 11: {
                if (value instanceof DateTime) break;
                throw new ClassCastException("Was expecting value of type DateTime for field 'datetime', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + setField);
            }
        }
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = 0;
        this.value_ = null;
        iprot.readStructBegin(metaDataMap);
        TField field = iprot.readFieldBegin();
        if (field.type != 0) {
            this.value_ = this.readValue(iprot, field);
            if (this.value_ != null) {
                switch (field.id) {
                    case 1: {
                        if (field.type != ColumnValue.BOOL_VAL_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 2: {
                        if (field.type != ColumnValue.INTEGER_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 3: {
                        if (field.type != ColumnValue.ID_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 4: {
                        if (field.type != ColumnValue.SINGLE_PRECISION_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 5: {
                        if (field.type != ColumnValue.DOUBLE_PRECISION_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 6: {
                        if (field.type != ColumnValue.STR_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 7: {
                        if (field.type != ColumnValue.TIMESTAMP_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 8: {
                        if (field.type != ColumnValue.YEAR_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 9: {
                        if (field.type != ColumnValue.MONTH_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 10: {
                        if (field.type != ColumnValue.DATE_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 11: {
                        if (field.type != ColumnValue.DATETIME_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                    }
                }
            }
            iprot.readFieldEnd();
            iprot.readFieldBegin();
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
    }

    @Override
    protected Object readValue(TProtocol iprot, TField field) throws TException {
        switch (field.id) {
            case 1: {
                if (field.type == ColumnValue.BOOL_VAL_FIELD_DESC.type) {
                    Boolean bool_val = iprot.readBool();
                    return bool_val;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 2: {
                if (field.type == ColumnValue.INTEGER_FIELD_DESC.type) {
                    Long integer = iprot.readI64();
                    return integer;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 3: {
                if (field.type == ColumnValue.ID_FIELD_DESC.type) {
                    Long id = iprot.readI64();
                    return id;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 4: {
                if (field.type == ColumnValue.SINGLE_PRECISION_FIELD_DESC.type) {
                    Float single_precision = Float.valueOf(iprot.readFloat());
                    return single_precision;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 5: {
                if (field.type == ColumnValue.DOUBLE_PRECISION_FIELD_DESC.type) {
                    Double double_precision = iprot.readDouble();
                    return double_precision;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 6: {
                if (field.type == ColumnValue.STR_FIELD_DESC.type) {
                    byte[] str = iprot.readBinary();
                    return str;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 7: {
                if (field.type == ColumnValue.TIMESTAMP_FIELD_DESC.type) {
                    Long timestamp = iprot.readI64();
                    return timestamp;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 8: {
                if (field.type == ColumnValue.YEAR_FIELD_DESC.type) {
                    Short year = iprot.readI16();
                    return year;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 9: {
                if (field.type == ColumnValue.MONTH_FIELD_DESC.type) {
                    YearMonth month = new YearMonth();
                    month.read(iprot);
                    return month;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 10: {
                if (field.type == ColumnValue.DATE_FIELD_DESC.type) {
                    Date date = new Date();
                    date.read(iprot);
                    return date;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 11: {
                if (field.type == ColumnValue.DATETIME_FIELD_DESC.type) {
                    DateTime datetime = new DateTime();
                    datetime.read(iprot);
                    return datetime;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
        }
        TProtocolUtil.skip(iprot, field.type);
        return null;
    }

    @Override
    protected void writeValue(TProtocol oprot, short setField, Object value) throws TException {
        switch (setField) {
            case 1: {
                Boolean bool_val = (Boolean)this.getFieldValue();
                oprot.writeBool(bool_val);
                return;
            }
            case 2: {
                Long integer = (Long)this.getFieldValue();
                oprot.writeI64(integer);
                return;
            }
            case 3: {
                Long id = (Long)this.getFieldValue();
                oprot.writeI64(id);
                return;
            }
            case 4: {
                Float single_precision = (Float)this.getFieldValue();
                oprot.writeFloat(single_precision.floatValue());
                return;
            }
            case 5: {
                Double double_precision = (Double)this.getFieldValue();
                oprot.writeDouble(double_precision);
                return;
            }
            case 6: {
                byte[] str = (byte[])this.getFieldValue();
                oprot.writeBinary(str);
                return;
            }
            case 7: {
                Long timestamp = (Long)this.getFieldValue();
                oprot.writeI64(timestamp);
                return;
            }
            case 8: {
                Short year = (Short)this.getFieldValue();
                oprot.writeI16(year);
                return;
            }
            case 9: {
                YearMonth month = (YearMonth)this.getFieldValue();
                month.write(oprot);
                return;
            }
            case 10: {
                Date date = (Date)this.getFieldValue();
                date.write(oprot);
                return;
            }
            case 11: {
                DateTime datetime = (DateTime)this.getFieldValue();
                datetime.write(oprot);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + setField);
    }

    @Override
    protected TField getFieldDesc(int setField) {
        switch (setField) {
            case 1: {
                return BOOL_VAL_FIELD_DESC;
            }
            case 2: {
                return INTEGER_FIELD_DESC;
            }
            case 3: {
                return ID_FIELD_DESC;
            }
            case 4: {
                return SINGLE_PRECISION_FIELD_DESC;
            }
            case 5: {
                return DOUBLE_PRECISION_FIELD_DESC;
            }
            case 6: {
                return STR_FIELD_DESC;
            }
            case 7: {
                return TIMESTAMP_FIELD_DESC;
            }
            case 8: {
                return YEAR_FIELD_DESC;
            }
            case 9: {
                return MONTH_FIELD_DESC;
            }
            case 10: {
                return DATE_FIELD_DESC;
            }
            case 11: {
                return DATETIME_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + setField);
    }

    @Override
    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    public boolean isBool_val() {
        if (this.getSetField() == 1) {
            return (Boolean)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'bool_val' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setBool_val(boolean value) {
        this.setField_ = 1;
        this.value_ = value;
    }

    public long getInteger() {
        if (this.getSetField() == 2) {
            return (Long)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'integer' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setInteger(long value) {
        this.setField_ = 2;
        this.value_ = value;
    }

    public long getId() {
        if (this.getSetField() == 3) {
            return (Long)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'id' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setId(long value) {
        this.setField_ = 3;
        this.value_ = value;
    }

    public float getSingle_precision() {
        if (this.getSetField() == 4) {
            return ((Float)this.getFieldValue()).floatValue();
        }
        throw new RuntimeException("Cannot get field 'single_precision' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setSingle_precision(float value) {
        this.setField_ = 4;
        this.value_ = Float.valueOf(value);
    }

    public double getDouble_precision() {
        if (this.getSetField() == 5) {
            return (Double)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'double_precision' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setDouble_precision(double value) {
        this.setField_ = 5;
        this.value_ = value;
    }

    public byte[] getStr() {
        if (this.getSetField() == 6) {
            return (byte[])this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'str' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setStr(byte[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 6;
        this.value_ = value;
    }

    public long getTimestamp() {
        if (this.getSetField() == 7) {
            return (Long)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'timestamp' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setTimestamp(long value) {
        this.setField_ = 7;
        this.value_ = value;
    }

    public short getYear() {
        if (this.getSetField() == 8) {
            return (Short)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'year' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setYear(short value) {
        this.setField_ = 8;
        this.value_ = value;
    }

    public YearMonth getMonth() {
        if (this.getSetField() == 9) {
            return (YearMonth)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'month' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setMonth(YearMonth value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 9;
        this.value_ = value;
    }

    public Date getDate() {
        if (this.getSetField() == 10) {
            return (Date)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'date' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setDate(Date value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 10;
        this.value_ = value;
    }

    public DateTime getDatetime() {
        if (this.getSetField() == 11) {
            return (DateTime)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'datetime' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setDatetime(DateTime value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 11;
        this.value_ = value;
    }

    public boolean equals(Object other) {
        if (other instanceof ColumnValue) {
            return this.equals((ColumnValue)other);
        }
        return false;
    }

    public boolean equals(ColumnValue other) {
        return this.equalsSlowImpl(other);
    }

    @Override
    public int compareTo(ColumnValue other) {
        return this.compareToImpl(other);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getSetField()).append(this.getFieldValue()).toHashCode();
    }

    @Override
    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ColumnValue");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        if (this.getSetField() == 1) {
            sb.append(indentStr);
            sb.append("bool_val");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.isBool_val(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 2) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("integer");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getInteger(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 3) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("id");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getId(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 4) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("single_precision");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(Float.valueOf(this.getSingle_precision()), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 5) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("double_precision");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getDouble_precision(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 6) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("str");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getStr() == null) {
                sb.append("null");
            } else {
                int __str_size = Math.min(this.getStr().length, 128);
                for (int i = 0; i < __str_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getStr()[i]).length() > 1 ? Integer.toHexString(this.getStr()[i]).substring(Integer.toHexString(this.getStr()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getStr()[i]).toUpperCase());
                }
                if (this.getStr().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        if (this.getSetField() == 7) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("timestamp");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getTimestamp(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 8) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("year");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getYear(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.getSetField() == 9) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("month");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getMonth() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getMonth(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.getSetField() == 10) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("date");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getDate() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getDate(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.getSetField() == 11) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("datetime");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getDatetime() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getDatetime(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("bool_val", 3, new FieldValueMetaData(2)));
        tmpMetaDataMap.put(2, new FieldMetaData("integer", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(3, new FieldMetaData("id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("single_precision", 3, new FieldValueMetaData(19)));
        tmpMetaDataMap.put(5, new FieldMetaData("double_precision", 3, new FieldValueMetaData(4)));
        tmpMetaDataMap.put(6, new FieldMetaData("str", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(7, new FieldMetaData("timestamp", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(8, new FieldMetaData("year", 3, new FieldValueMetaData(6)));
        tmpMetaDataMap.put(9, new FieldMetaData("month", 3, new StructMetaData(12, YearMonth.class)));
        tmpMetaDataMap.put(10, new FieldMetaData("date", 3, new StructMetaData(12, Date.class)));
        tmpMetaDataMap.put(11, new FieldMetaData("datetime", 3, new StructMetaData(12, DateTime.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
    }
}

