/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TJSONProtocol;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import java.util.Collections;

public class TProtocolUtil {
    private static int maxSkipDepth = Integer.MAX_VALUE;

    public static void setMaxSkipDepth(int depth) {
        maxSkipDepth = depth;
    }

    public static void skip(TProtocol prot, byte type) throws TException {
        TProtocolUtil.skip(prot, type, maxSkipDepth);
    }

    public static void skip(TProtocol prot, byte type, int maxDepth) throws TException {
        if (maxDepth <= 0) {
            throw new TException("Maximum skip depth exceeded");
        }
        switch (type) {
            case 2: {
                prot.readBool();
                break;
            }
            case 3: {
                prot.readByte();
                break;
            }
            case 6: {
                prot.readI16();
                break;
            }
            case 8: {
                prot.readI32();
                break;
            }
            case 10: {
                prot.readI64();
                break;
            }
            case 4: {
                prot.readDouble();
                break;
            }
            case 19: {
                prot.readFloat();
                break;
            }
            case 11: {
                prot.readBinary();
                break;
            }
            case 12: {
                prot.readStructBegin(Collections.<Integer, FieldMetaData>emptyMap());
                while (true) {
                    TField field = prot.readFieldBegin();
                    if (field.type == 0) break;
                    TProtocolUtil.skip(prot, field.type, maxDepth - 1);
                    prot.readFieldEnd();
                }
                prot.readStructEnd();
                break;
            }
            case 13: {
                TMap map = prot.readMapBegin();
                int i = 0;
                while (map.size < 0 ? prot.peekMap() : i < map.size) {
                    TProtocolUtil.skip(prot, map.keyType, maxDepth - 1);
                    TProtocolUtil.skip(prot, map.valueType, maxDepth - 1);
                    ++i;
                }
                prot.readMapEnd();
                break;
            }
            case 14: {
                TSet set = prot.readSetBegin();
                int i = 0;
                while (set.size < 0 ? prot.peekSet() : i < set.size) {
                    TProtocolUtil.skip(prot, set.elemType, maxDepth - 1);
                    ++i;
                }
                prot.readSetEnd();
                break;
            }
            case 15: {
                TList list = prot.readListBegin();
                int i = 0;
                while (list.size < 0 ? prot.peekList() : i < list.size) {
                    TProtocolUtil.skip(prot, list.elemType, maxDepth - 1);
                    ++i;
                }
                prot.readListEnd();
                break;
            }
        }
    }

    public static TProtocolFactory guessProtocolFactory(byte[] data, TProtocolFactory fallback) {
        if (123 == data[0] && 125 == data[data.length - 1]) {
            return new TJSONProtocol.Factory();
        }
        if (data[data.length - 1] != 0) {
            return new TBinaryProtocol.Factory();
        }
        if (data[0] > 16) {
            return new TCompactProtocol.Factory();
        }
        if (data.length > 1 && 0 == data[1]) {
            return new TBinaryProtocol.Factory();
        }
        if (data.length > 1 && (data[1] & 0x80) != 0) {
            return new TCompactProtocol.Factory();
        }
        return fallback;
    }
}

