/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.support.utils.ActivityUtils;
import com.verizon.ads.webview.VASAdsWebView;

public class VASAdsWebViewClient
extends WebViewClient {
    private static final String WHO = VASAdsWebViewClient.class.getSimpleName();
    private static final int ERROR_WEBVIEW = -1;

    public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
        if (webView instanceof VASAdsWebView) {
            VASAdsWebView vasAdsWebView = (VASAdsWebView)webView;
            String errorDescription = String.format("WebView error code: %d, description: %s, failing url: %s", errorCode, description, failingUrl);
            vasAdsWebView.webViewListener.onError(new ErrorInfo(WHO, errorDescription, -1));
        }
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String url) {
        if (webView instanceof VASAdsWebView) {
            VASAdsWebView vasAdsWebView = (VASAdsWebView)webView;
            if (vasAdsWebView.isOriginalUrl(url)) {
                return true;
            }
            if (ActivityUtils.startActivityFromUrl((Context)webView.getContext(), (String)url)) {
                vasAdsWebView.webViewListener.onAdLeftApplication(vasAdsWebView);
            }
            return true;
        }
        return false;
    }

    @RequiresApi(api=26)
    public boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
        ViewParent viewParent;
        super.onRenderProcessGone(view, detail);
        if (view != null && (viewParent = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)view);
            view.destroy();
        }
        return true;
    }
}

