/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.PointF;
import android.graphics.Rect;
import android.location.Location;
import android.media.AudioManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebViewClient;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import com.verizon.ads.support.TimedMemoryCache;
import com.verizon.ads.support.VASActivity;
import com.verizon.ads.support.utils.ActivityUtils;
import com.verizon.ads.support.utils.ViewUtils;
import com.verizon.ads.support.utils.ViewabilityWatcher;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.webview.MRAIDExpandedActivity;
import com.verizon.ads.webview.MediaUtils;
import com.verizon.ads.webview.R;
import com.verizon.ads.webview.VASAdsWebView;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class VASAdsMRAIDWebView
extends VASAdsWebView {
    private static final Logger logger = Logger.getInstance(VASAdsMRAIDWebView.class);
    private static final int EXPOSURE_POLLING_INTERVAL_MILLIS = 200;
    private static TimedMemoryCache<VASAdsMRAIDWebView> webViewTimedMemoryCache;
    private static final int LOCATION_UPDATE_DELAY = 5000;
    private static final long WEBVIEW_CACHE_TIMEOUT = 5000L;
    private static final Pattern mraidJsReplacePattern;
    private final VolumeChangeContentObserver volumeChangeContentObserver;
    private boolean immersive = true;
    private boolean interstitial;
    private int lastOrientation;
    private JSBridgeMRAID jsBridgeMRAID;
    private ViewabilityWatcher viewabilityWatcher;
    private boolean dispatchExposureUpdates = false;
    private float lastExposedPercentage;
    private Rect lastMinimumBoundingRectangle;
    private View closeIndicator;
    private UpdateLocationTask updateLocationTask;
    private ViewGroup defaultContainer;
    private ViewGroup.LayoutParams defaultLayoutParams;
    private Rect defaultDimensions;
    private PointF defaultTranslation;
    public static final String MRAID_RESIZE_CLOSE_INDICATOR = "MRAID_RESIZE_CLOSE_INDICATOR";

    @SuppressLint(value={"AddJavascriptInterface"})
    public VASAdsMRAIDWebView(Context context, boolean interstitial, VASAdsMRAIDWebViewListener webViewListener) {
        super(context, webViewListener);
        this.interstitial = interstitial;
        this.lastOrientation = this.getContext().getResources().getConfiguration().orientation;
        this.jsBridgeMRAID = new JSBridgeMRAID();
        this.addJavascriptInterface(this.jsBridgeMRAID, "MmInjectedFunctionsMraid");
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (view instanceof VASAdsMRAIDWebView) {
                    int newOrientation = VASAdsMRAIDWebView.this.getContext().getResources().getConfiguration().orientation;
                    if (VASAdsMRAIDWebView.this.lastOrientation != newOrientation) {
                        if (Logger.isLogLevelEnabled((int)3)) {
                            logger.d(String.format("Detected change in orientation to %s", new EnvironmentInfo(VASAdsMRAIDWebView.this.getContext()).getDeviceInfo().getConfigurationOrientation()));
                        }
                        VASAdsMRAIDWebView.this.lastOrientation = newOrientation;
                        VASAdsMRAIDWebView.this.jsBridgeMRAID.sendPositions();
                    }
                }
            }
        });
        this.viewabilityWatcher = new ViewabilityWatcher((View)this, (ViewabilityWatcher.ViewabilityListener)this.jsBridgeMRAID);
        this.viewabilityWatcher.startWatching();
        this.volumeChangeContentObserver = new VolumeChangeContentObserver(context, this.jsBridgeMRAID);
        if (interstitial) {
            this.closeIndicator = new ImageView(this.getContext());
            ((ImageView)this.closeIndicator).setImageResource(R.drawable.mraid_close);
        } else {
            this.closeIndicator = new View(this.getContext());
            this.closeIndicator.setVisibility(8);
        }
        this.closeIndicator.setTag((Object)MRAID_RESIZE_CLOSE_INDICATOR);
        this.closeIndicator.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASAdsMRAIDWebView.this.close();
            }
        });
        int width = (int)this.getResources().getDimension(R.dimen.close_region_width);
        int height = (int)this.getResources().getDimension(R.dimen.close_region_height);
        this.addView(this.closeIndicator, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(width, height, 0, 0));
    }

    VASAdsMRAIDWebView getTwoPartWebView() {
        return new TwoPartExpandWebView(this.getContext(), this, this.getWebViewListener());
    }

    public void setImmersive(boolean immersive) {
        this.immersive = immersive;
    }

    public boolean isImmersive() {
        return this.immersive;
    }

    @Override
    public void release() {
        if (this.jsBridgeMRAID != null && this.jsBridgeMRAID.scrollHandlerThread != null) {
            this.jsBridgeMRAID.scrollHandlerThread.quit();
        }
        if (this.volumeChangeContentObserver != null) {
            ContentResolver contentResolver;
            this.volumeChangeContentObserver.stopDispatchThread();
            Context context = this.getContext();
            if (context != null && (contentResolver = context.getContentResolver()) != null) {
                contentResolver.unregisterContentObserver((ContentObserver)this.volumeChangeContentObserver);
            }
        }
        this.close();
        super.release();
    }

    @Override
    protected List<String> getExtraScriptsToLoad() {
        return Collections.singletonList("vas/mraid.js");
    }

    @Override
    protected VASAdsWebView.VASAdsWebViewListener getNoOpWebViewListener() {
        return new VASAdsMRAIDWebViewListener(){

            @Override
            public void close() {
            }

            @Override
            public void expand() {
            }

            @Override
            public void resize() {
            }

            @Override
            public void unload() {
            }

            @Override
            public void onError(ErrorInfo errorInfo) {
            }

            @Override
            public void onAdLeftApplication(VASAdsWebView vasAdsWebView) {
            }

            @Override
            public void onClicked(VASAdsWebView vasAdsWebView) {
            }
        };
    }

    @Override
    protected void onLoadComplete(ErrorInfo errorInfo) {
        this.jsBridgeMRAID.javascriptReady = true;
        this.jsBridgeMRAID.setReadyState();
        VASAdsMRAIDWebView.super.onLoadComplete(null);
    }

    protected void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        super.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        this.jsBridgeMRAID.setCurrentPosition();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (changed) {
            int width = (int)this.getResources().getDimension(R.dimen.close_region_width);
            int x = r - l - width;
            AbsoluteLayout.LayoutParams layoutParams = (AbsoluteLayout.LayoutParams)this.closeIndicator.getLayoutParams();
            layoutParams.x = x;
        }
        super.onLayout(changed, l, t, r, b);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getLocationOnScreen(this.jsBridgeMRAID.lastPosition);
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.jsBridgeMRAID);
        }
        this.dispatchExposureUpdates = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!(VASAdsMRAIDWebView.this.viewabilityWatcher == null || VASAdsMRAIDWebView.isEqual(((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.mbr, VASAdsMRAIDWebView.this.lastMinimumBoundingRectangle) && VASAdsMRAIDWebView.this.lastExposedPercentage == ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.exposedPercentage)) {
                    VASAdsMRAIDWebView.this.lastExposedPercentage = ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.exposedPercentage;
                    VASAdsMRAIDWebView.this.lastMinimumBoundingRectangle = ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.mbr;
                    VASAdsMRAIDWebView.this.jsBridgeMRAID.sendExposureChange(VASAdsMRAIDWebView.this.lastExposedPercentage, VASAdsMRAIDWebView.this.lastMinimumBoundingRectangle);
                }
                if (VASAdsMRAIDWebView.this.dispatchExposureUpdates) {
                    VASAdsMRAIDWebView.this.postDelayed(this, 200L);
                } else {
                    logger.d("Stopping exposureChange notifications.");
                }
            }
        });
        this.jsBridgeMRAID.startLocationUpdates();
    }

    public void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.jsBridgeMRAID);
        }
        this.dispatchExposureUpdates = false;
        this.jsBridgeMRAID.stopLocationUpdates();
        super.onDetachedFromWindow();
    }

    protected String getInitialState() {
        return "default";
    }

    @Override
    protected String buildScriptStatements(Collection<String> scriptAssets) {
        StringBuilder sb = new StringBuilder(40);
        try {
            EnvironmentInfo environmentInfo;
            EnvironmentInfo.AdvertisingIdInfo advertisingIdInfo;
            JSONObject mraidEnv = new JSONObject();
            mraidEnv.put("version", (Object)"3.0");
            mraidEnv.put("sdk", (Object)"Verizon Ads MRAID WebView");
            mraidEnv.put("sdkVersion", (Object)"1.0");
            if (VASAds.isShareApplicationIdEnabled()) {
                mraidEnv.put("appId", (Object)this.getContext().getPackageName());
            }
            if (VASAds.isShareAdvertiserIdEnabled() && (advertisingIdInfo = (environmentInfo = new EnvironmentInfo(this.getContext())).getAdvertisingIdInfo()) != null) {
                mraidEnv.put("ifa", (Object)advertisingIdInfo.getId());
                mraidEnv.put("limitAdTracking", advertisingIdInfo.isLimitAdTrackingEnabled());
            }
            mraidEnv.put("coppa", VASAds.getCoppa() != null && VASAds.getCoppa() != false);
            sb.append("<script>\nwindow.MRAID_ENV = ").append(mraidEnv.toString(4)).append("\n</script>");
        }
        catch (JSONException e) {
            logger.e("MRAID_ENV could not be configured.", (Throwable)e);
        }
        sb.append(super.buildScriptStatements(scriptAssets));
        return sb.toString();
    }

    @Override
    protected String postProcessContent(String content) {
        String postProcessedContent = content;
        Matcher matcher = mraidJsReplacePattern.matcher(content);
        if (matcher.find(0)) {
            postProcessedContent = matcher.replaceAll("");
        }
        return postProcessedContent;
    }

    static VASAdsMRAIDWebView getCachedWebView(String cachedId) {
        return (VASAdsMRAIDWebView)((Object)webViewTimedMemoryCache.get(cachedId));
    }

    VASAdsMRAIDWebViewListener getWebViewListener() {
        return (VASAdsMRAIDWebViewListener)this.webViewListener;
    }

    void setExpanded() {
        this.jsBridgeMRAID.setState("expanded");
        this.getWebViewListener().expand();
    }

    void throwMraidError(String message, String actionName) {
        this.jsBridgeMRAID.throwMraidError(message, actionName);
    }

    void close() {
        this.jsBridgeMRAID.close(null);
    }

    private static boolean isEqual(Rect r1, Rect r2) {
        if (r1 == null) {
            return r2 == null;
        }
        return r1.equals((Object)r2);
    }

    public static Float getCurrentVolume(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            logger.w("Unable to get a reference to the AudioManager.");
            return null;
        }
        int volume = audioManager.getStreamVolume(3);
        int maxVolume = audioManager.getStreamMaxVolume(3);
        return Float.valueOf((float)volume / (float)maxVolume * 100.0f);
    }

    static {
        mraidJsReplacePattern = Pattern.compile("<script\\s+[^>]*\\bsrc\\s*=\\s*([\\\"\\'])mraid\\.js\\1[^>]*>\\s*</script\\s*>", 2);
        webViewTimedMemoryCache = new TimedMemoryCache();
    }

    private static class VolumeChangeContentObserver
    extends ContentObserver {
        private HandlerThread handlerThread;
        private Handler handler;
        private Context context;
        private int volume;
        private int maxVolume;
        private VolumeChangeListener listener;

        @SuppressLint(value={"DefaultLocale"})
        VolumeChangeContentObserver(Context context, VolumeChangeListener listener) {
            super(null);
            this.listener = listener;
            this.context = context;
            this.handlerThread = new HandlerThread("VolumeChangeDispatcher");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            if (audioManager != null) {
                this.volume = audioManager.getStreamVolume(3);
                this.maxVolume = audioManager.getStreamMaxVolume(3);
            } else {
                logger.w("Unable to get a reference to the AudioManager.");
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("VolumeChangeContentObserver created with initial vol = %d, max vol = %d", this.volume, this.maxVolume));
            }
            context.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this);
        }

        @SuppressLint(value={"DefaultLocale"})
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Setting changed for URI = %s", uri));
            }
            if (uri.toString().startsWith("content://settings/system/volume_music_")) {
                this.dispatchVolumeChange();
            }
        }

        @SuppressLint(value={"DefaultLocale"})
        private void dispatchVolumeChange() {
            AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
            if (audioManager == null) {
                logger.w("Unable to obtain a reference to the AudioManager.");
                return;
            }
            final int currentVolume = audioManager.getStreamVolume(3);
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Current volume vol = %d, last vol = %d", currentVolume, this.volume));
            }
            if (currentVolume != this.volume) {
                final int oldVolume = this.volume;
                this.volume = currentVolume;
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d(String.format("Dispatching volume change old vol = %d, new vol = %d", oldVolume, currentVolume));
                }
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onVolumeChange(oldVolume, currentVolume, maxVolume);
                        }
                    }
                });
            }
        }

        void stopDispatchThread() {
            if (this.handlerThread != null) {
                this.handlerThread.quit();
                this.handlerThread = null;
            }
        }
    }

    private static interface VolumeChangeListener {
        public void onVolumeChange(int var1, int var2, int var3);
    }

    static class TwoPartExpandWebView
    extends VASAdsMRAIDWebView {
        VASAdsMRAIDWebView firstPartWebView;

        TwoPartExpandWebView(Context context, VASAdsMRAIDWebView firstPartWebView, VASAdsMRAIDWebViewListener webViewListener) {
            super(context, false, webViewListener);
            this.firstPartWebView = firstPartWebView;
            this.setWebViewClient(new WebViewClient());
        }

        void closeFirstPart() {
            this.firstPartWebView.close();
        }

        void unloadFirstPart() {
            this.firstPartWebView.jsBridgeMRAID.unload(null);
        }

        @Override
        protected String getInitialState() {
            return "expanded";
        }
    }

    class JSBridgeMRAID
    implements ViewTreeObserver.OnScrollChangedListener,
    ViewabilityWatcher.ViewabilityListener,
    VolumeChangeListener {
        private static final String JS_MRAID_NAMESPACE = "MmJsBridge.mraid";
        private static final String JS_THROW_MRAID_ERROR = "MmJsBridge.mraid.throwMraidError";
        private static final String JS_SET_POSITIONS = "MmJsBridge.mraid.setPositions";
        private static final String JS_SET_SUPPORTS = "MmJsBridge.mraid.setSupports";
        private static final String JS_SET_VIEWABLE = "MmJsBridge.mraid.setViewable";
        private static final String JS_SET_STATE = "MmJsBridge.mraid.setState";
        private static final String JS_SET_PLACEMENT_TYPE = "MmJsBridge.mraid.setPlacementType";
        private static final String JS_SET_LOCATION = "MmJsBridge.mraid.setLocation";
        private static final String JS_SET_VOLUME = "MmJsBridge.mraid.setVolume";
        private static final String JS_SET_EXPOSURE_CHANGE = "MmJsBridge.mraid.setExposureChange";
        private static final String AD_NOT_CLICKED_MESSAGE = "Ad has not been clicked";
        private static final String NOT_SUPPORTED_MESSAGE = "Not supported";
        private static final String URL_OPEN_FAILED_MESSAGE = "Unable to open url <%s>";
        private static final String RESIZE_FAILED_MESSAGE = "Unable to resize";
        private static final String CANNOT_EXPAND_INTERSTITIAL_MESSAGE = "Cannot expand interstitial";
        private static final String CANNOT_RESIZE_INTERSTITIAL_MESSAGE = "Cannot resize interstitial";
        private static final String CANNOT_EXPAND_STATE_MESSAGE = "Cannot expand in current state<%s>";
        private static final String CANNOT_RESIZE_STATE_MESSAGE = "Cannot resize in current state<%s>";
        private static final String INVALID_ORIENTATION_MESSAGE = "Invalid orientation specified <%s>";
        private static final String SET_ORIENTATION_FAILED_MESSAGE = "Cannot apply requested orientation.";
        private static final String NO_VIDEO_PATH_MESSAGE = "No path specified for video";
        private static final String URL_KEY = "url";
        private static final String WIDTH_KEY = "width";
        private static final String HEIGHT_KEY = "height";
        private static final String RESIZE_MRAID_OP = "resize";
        private static final String CREATE_CALENDAR_EVENT_MRAID_OP = "createCalendarEvent";
        private static final String PLAY_VIDEO_MRAID_OP = "playVideo";
        private static final String SET_ORIENTATION_PROPERTIES_OP = "setOrientationProperties";
        private static final String SUPPORTS_CALENDAR = "calendar";
        private static final String SUPPORTS_STORE_PICTURE = "storePicture";
        private static final String SUPPORTS_INLINE_VIDEO = "inlineVideo";
        private static final String SUPPORTS_TEL = "tel";
        private static final String SUPPORTS_SMS = "sms";
        private static final String SUPPORTS_VPAID = "vpaid";
        private static final String SUPPORTS_LOCATION = "location";
        private static final String STATE_LOADING = "loading";
        private static final String STATE_DEFAULT = "default";
        private static final String STATE_RESIZED = "resized";
        private static final String STATE_EXPANDED = "expanded";
        private static final String STATE_HIDDEN = "hidden";
        static final String EXPAND_FAILED_MESSAGE = "Unable to expand";
        static final String EXPAND_MRAID_OP = "expand";
        boolean locationUpdatesEnabled;
        Location lastLocation;
        String currentState = "loading";
        int requestedOrientation = -1;
        volatile boolean ready;
        volatile boolean viewable;
        volatile boolean hasSize;
        volatile boolean resizing;
        volatile boolean javascriptReady;
        int[] currentPosition = new int[2];
        int[] lastPosition = new int[2];
        Handler scrollHandler;
        HandlerThread scrollHandlerThread = new HandlerThread(this.getClass().getSimpleName() + "[" + this + "]: ScrollHandler");

        JSBridgeMRAID() {
            this.scrollHandlerThread.start();
            this.scrollHandler = new ScrollHandler(this);
        }

        @JavascriptInterface
        public void open(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: open(%s)", args));
            }
            if (VASAdsMRAIDWebView.this.hasNotBeenTouched()) {
                this.throwMraidError(AD_NOT_CLICKED_MESSAGE, "open");
                return;
            }
            JSONObject json = new JSONObject(args);
            String url = json.getString(URL_KEY);
            EnvironmentInfo environmentInfo = new EnvironmentInfo(VASAdsMRAIDWebView.this.getContext());
            if (environmentInfo.isCustomTabsSupported() && ActivityUtils.startCustomTabActivityFromUrl((Context)ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this), (String)url)) {
                logger.d("Custom tabs are supported; opening URL in custom tab.");
            } else if (ActivityUtils.startActivityFromUrl((Context)VASAdsMRAIDWebView.this.getContext(), (String)url)) {
                VASAdsMRAIDWebView.this.getWebViewListener().onAdLeftApplication(VASAdsMRAIDWebView.this);
            } else {
                this.throwMraidError(String.format(URL_OPEN_FAILED_MESSAGE, url), "open");
            }
        }

        @JavascriptInterface
        public void close(String args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: close(%s)", args));
            }
            ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TextUtils.equals((CharSequence)JSBridgeMRAID.STATE_LOADING, (CharSequence)((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).jsBridgeMRAID.currentState)) {
                        return;
                    }
                    if (VASAdsMRAIDWebView.this.interstitial) {
                        VASAdsMRAIDWebView.this.jsBridgeMRAID.setState(JSBridgeMRAID.STATE_HIDDEN);
                    } else if (TextUtils.equals((CharSequence)JSBridgeMRAID.STATE_EXPANDED, (CharSequence)((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).jsBridgeMRAID.currentState) || TextUtils.equals((CharSequence)JSBridgeMRAID.STATE_RESIZED, (CharSequence)((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).jsBridgeMRAID.currentState)) {
                        if (TextUtils.equals((CharSequence)JSBridgeMRAID.STATE_EXPANDED, (CharSequence)((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).jsBridgeMRAID.currentState)) {
                            Activity activity = ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this);
                            if (activity instanceof MRAIDExpandedActivity) {
                                activity.finish();
                            }
                            if (VASAdsMRAIDWebView.this instanceof TwoPartExpandWebView) {
                                TwoPartExpandWebView twoPartWebView = (TwoPartExpandWebView)VASAdsMRAIDWebView.this;
                                twoPartWebView.closeFirstPart();
                            }
                        }
                        if (VASAdsMRAIDWebView.this.defaultContainer != null) {
                            if (TextUtils.equals((CharSequence)JSBridgeMRAID.STATE_RESIZED, (CharSequence)((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).jsBridgeMRAID.currentState)) {
                                JSBridgeMRAID.this.removeResizeContainerFromWindow();
                            }
                            ViewUtils.removeFromParent((View)VASAdsMRAIDWebView.this);
                            Activity containerActivity = ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this.defaultContainer);
                            if (containerActivity != null) {
                                MutableContextWrapper mutableContextWrapper = (MutableContextWrapper)VASAdsMRAIDWebView.this.getContext();
                                mutableContextWrapper.setBaseContext((Context)containerActivity);
                                if (VASAdsMRAIDWebView.this.defaultTranslation != null) {
                                    VASAdsMRAIDWebView.this.setTranslationX(((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultTranslation.x);
                                    VASAdsMRAIDWebView.this.setTranslationY(((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultTranslation.y);
                                }
                                VASAdsMRAIDWebView.this.defaultContainer.addView((View)VASAdsMRAIDWebView.this, VASAdsMRAIDWebView.this.defaultLayoutParams);
                            }
                            VASAdsMRAIDWebView.this.defaultContainer = null;
                            VASAdsMRAIDWebView.this.defaultDimensions = null;
                            VASAdsMRAIDWebView.this.defaultLayoutParams = null;
                            VASAdsMRAIDWebView.this.defaultTranslation = null;
                        }
                        VASAdsMRAIDWebView.this.jsBridgeMRAID.setState(JSBridgeMRAID.STATE_DEFAULT);
                    }
                    VASAdsMRAIDWebView.this.closeIndicator.setVisibility(8);
                    if (!(VASAdsMRAIDWebView.this instanceof TwoPartExpandWebView)) {
                        VASAdsMRAIDWebView.this.getWebViewListener().close();
                    }
                }
            });
        }

        private void removeResizeContainerFromWindow() {
            WindowManager windowManager = (WindowManager)VASAdsMRAIDWebView.this.getContext().getSystemService("window");
            if (windowManager != null) {
                View resizeContainer = (View)VASAdsMRAIDWebView.this.getParent();
                windowManager.removeView(resizeContainer);
            }
        }

        @JavascriptInterface
        public void unload(String args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: unload(%s)", args));
            }
            if (VASAdsMRAIDWebView.this instanceof TwoPartExpandWebView) {
                TwoPartExpandWebView twoPartExpandWebView = (TwoPartExpandWebView)VASAdsMRAIDWebView.this;
                twoPartExpandWebView.unloadFirstPart();
            }
            ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewUtils.removeFromParent((View)VASAdsMRAIDWebView.this);
                    Activity activity = ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this);
                    if (activity instanceof MRAIDExpandedActivity) {
                        activity.finish();
                    }
                    if (!(VASAdsMRAIDWebView.this instanceof TwoPartExpandWebView)) {
                        VASAdsMRAIDWebView.this.getWebViewListener().unload();
                    }
                }
            });
        }

        @JavascriptInterface
        public void expand(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: expand(%s)", args));
            }
            if (VASAdsMRAIDWebView.this.hasNotBeenTouched()) {
                this.throwMraidError(AD_NOT_CLICKED_MESSAGE, EXPAND_MRAID_OP);
                return;
            }
            JSONObject json = new JSONObject(args);
            if (VASAdsMRAIDWebView.this.interstitial) {
                this.throwMraidError(CANNOT_EXPAND_INTERSTITIAL_MESSAGE, EXPAND_MRAID_OP);
                return;
            }
            DisplayMetrics metrics = VASAdsMRAIDWebView.this.getContext().getResources().getDisplayMetrics();
            EnvironmentInfo environmentInfo = new EnvironmentInfo(VASAdsMRAIDWebView.this.getContext());
            EnvironmentInfo.ScreenInfo screenInfo = environmentInfo.getDeviceInfo().getScreenInfo();
            final ExpandParams expandParams = new ExpandParams();
            expandParams.width = json.has(WIDTH_KEY) ? Math.min((int)TypedValue.applyDimension((int)1, (float)json.getInt(WIDTH_KEY), (DisplayMetrics)metrics), screenInfo.getWidth()) : -1;
            expandParams.height = json.has(HEIGHT_KEY) ? Math.min((int)TypedValue.applyDimension((int)1, (float)json.getInt(HEIGHT_KEY), (DisplayMetrics)metrics), screenInfo.getHeight()) : -1;
            expandParams.orientation = this.requestedOrientation;
            expandParams.url = json.optString(URL_KEY, null);
            VASAdsMRAIDWebView.this.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    if (TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_EXPANDED) || TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_HIDDEN) || TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_LOADING)) {
                        JSBridgeMRAID.this.throwMraidError(String.format(JSBridgeMRAID.CANNOT_EXPAND_STATE_MESSAGE, JSBridgeMRAID.this.currentState), JSBridgeMRAID.EXPAND_MRAID_OP);
                        return;
                    }
                    Intent expandIntent = new Intent(VASAdsMRAIDWebView.this.getContext(), MRAIDExpandedActivity.class);
                    String cachedId = webViewTimedMemoryCache.add((Object)VASAdsMRAIDWebView.this, Long.valueOf(5000L));
                    expandIntent.putExtra("webview_cached_id", cachedId);
                    expandIntent.putExtra("expand_width", expandParams.width);
                    expandIntent.putExtra("expand_height", expandParams.height);
                    expandIntent.putExtra("orientation", expandParams.orientation);
                    expandIntent.putExtra("immersive", VASAdsMRAIDWebView.this.immersive);
                    if (TextUtils.isEmpty((CharSequence)expandParams.url)) {
                        if (TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_RESIZED)) {
                            JSBridgeMRAID.this.removeResizeContainerFromWindow();
                            ViewUtils.removeFromParent((View)VASAdsMRAIDWebView.this);
                            VASAdsMRAIDWebView.this.setTranslationX(0.0f);
                            VASAdsMRAIDWebView.this.setTranslationY(0.0f);
                        } else {
                            ViewParent viewParent = VASAdsMRAIDWebView.this.getParent();
                            if (!(viewParent instanceof ViewGroup)) {
                                logger.e("WebView parent is not a ViewGroup. Expansion cannot proceed.");
                                JSBridgeMRAID.this.throwMraidError(JSBridgeMRAID.EXPAND_FAILED_MESSAGE, JSBridgeMRAID.EXPAND_MRAID_OP);
                                return;
                            }
                            VASAdsMRAIDWebView.this.defaultContainer = (ViewGroup)viewParent;
                            VASAdsMRAIDWebView.this.defaultLayoutParams = VASAdsMRAIDWebView.this.getLayoutParams();
                            ViewUtils.removeFromParent((View)VASAdsMRAIDWebView.this);
                        }
                    } else {
                        expandIntent.putExtra(JSBridgeMRAID.URL_KEY, expandParams.url);
                    }
                    VASAdsMRAIDWebView.this.getContext().startActivity(expandIntent);
                }
            });
        }

        @JavascriptInterface
        public void resize(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: resize(%s)", args));
            }
            if (VASAdsMRAIDWebView.this.hasNotBeenTouched()) {
                this.throwMraidError(AD_NOT_CLICKED_MESSAGE, RESIZE_MRAID_OP);
                return;
            }
            JSONObject json = new JSONObject(args);
            if (VASAdsMRAIDWebView.this.interstitial) {
                this.throwMraidError(CANNOT_RESIZE_INTERSTITIAL_MESSAGE, RESIZE_MRAID_OP);
                return;
            }
            DisplayMetrics metrics = VASAdsMRAIDWebView.this.getContext().getResources().getDisplayMetrics();
            final ResizeParams resizeParams = new ResizeParams();
            resizeParams.width = (int)TypedValue.applyDimension((int)1, (float)json.getInt(WIDTH_KEY), (DisplayMetrics)metrics);
            resizeParams.height = (int)TypedValue.applyDimension((int)1, (float)json.getInt(HEIGHT_KEY), (DisplayMetrics)metrics);
            resizeParams.offsetX = (int)TypedValue.applyDimension((int)1, (float)json.optInt("offsetX", 0), (DisplayMetrics)metrics);
            resizeParams.offsetY = (int)TypedValue.applyDimension((int)1, (float)json.optInt("offsetY", 0), (DisplayMetrics)metrics);
            resizeParams.allowOffScreen = json.optBoolean("allowOffscreen", true);
            VASAdsMRAIDWebView.this.post(new Runnable(){

                @Override
                @SuppressLint(value={"RtlHardcoded"})
                public void run() {
                    if (TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_EXPANDED) || TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_HIDDEN) || TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_LOADING)) {
                        JSBridgeMRAID.this.throwMraidError(String.format(JSBridgeMRAID.CANNOT_RESIZE_STATE_MESSAGE, JSBridgeMRAID.this.currentState), JSBridgeMRAID.RESIZE_MRAID_OP);
                        return;
                    }
                    WindowManager windowManager = (WindowManager)VASAdsMRAIDWebView.this.getContext().getSystemService("window");
                    if (windowManager == null) {
                        JSBridgeMRAID.this.throwMraidError(JSBridgeMRAID.RESIZE_FAILED_MESSAGE, JSBridgeMRAID.RESIZE_MRAID_OP);
                        return;
                    }
                    Rect maxSize = JSBridgeMRAID.this.getMaxSize(windowManager);
                    if (VASAdsMRAIDWebView.this.defaultContainer == null) {
                        ViewParent viewParent = VASAdsMRAIDWebView.this.getParent();
                        if (viewParent instanceof ViewGroup) {
                            VASAdsMRAIDWebView.this.defaultContainer = (ViewGroup)viewParent;
                            VASAdsMRAIDWebView.this.defaultLayoutParams = VASAdsMRAIDWebView.this.getLayoutParams();
                            VASAdsMRAIDWebView.this.defaultDimensions = JSBridgeMRAID.this.getDimensionsForWebView();
                            VASAdsMRAIDWebView.this.defaultTranslation = new PointF();
                            ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultTranslation.x = VASAdsMRAIDWebView.this.getTranslationX();
                            ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultTranslation.y = VASAdsMRAIDWebView.this.getTranslationY();
                        } else {
                            logger.e("WebView parent is not a ViewGroup. Resize cannot proceed.");
                            JSBridgeMRAID.this.throwMraidError(JSBridgeMRAID.RESIZE_FAILED_MESSAGE, JSBridgeMRAID.RESIZE_MRAID_OP);
                            return;
                        }
                    }
                    int new_x = ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultDimensions.left + resizeParams.offsetX;
                    int new_y = ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).defaultDimensions.top + resizeParams.offsetY;
                    int new_width = resizeParams.width;
                    int new_height = resizeParams.height;
                    Rect resizeDimensions = new Rect(new_x, new_y, new_x + new_width, new_y + new_height);
                    if (!resizeParams.allowOffScreen && !maxSize.contains(resizeDimensions)) {
                        int shiftedBottom;
                        int shiftedRight;
                        if (resizeDimensions.right > maxSize.right) {
                            int shiftedLeft = resizeDimensions.left - (resizeDimensions.right - maxSize.right);
                            if (shiftedLeft >= maxSize.left) {
                                resizeDimensions.left = shiftedLeft;
                                resizeDimensions.right = maxSize.right;
                            }
                        } else if (resizeDimensions.left < maxSize.left && (shiftedRight = resizeDimensions.right + (maxSize.left - resizeDimensions.left)) <= maxSize.right) {
                            resizeDimensions.right = shiftedRight;
                            resizeDimensions.left = maxSize.left;
                        }
                        if (resizeDimensions.bottom > maxSize.bottom) {
                            int shiftedTop = resizeDimensions.top - (resizeDimensions.bottom - maxSize.bottom);
                            if (shiftedTop >= maxSize.top) {
                                resizeDimensions.top = shiftedTop;
                                resizeDimensions.bottom = maxSize.bottom;
                            }
                        } else if (resizeDimensions.top < maxSize.top && (shiftedBottom = resizeDimensions.bottom + (maxSize.top - resizeDimensions.top)) <= maxSize.bottom) {
                            resizeDimensions.bottom = shiftedBottom;
                            resizeDimensions.top = maxSize.top;
                        }
                        if (!maxSize.contains(resizeDimensions)) {
                            logger.e("Resize dimensions will place ad offscreen and allow offscreen is not permitted.");
                            VASAdsMRAIDWebView.this.throwMraidError(JSBridgeMRAID.RESIZE_FAILED_MESSAGE, JSBridgeMRAID.RESIZE_MRAID_OP);
                            return;
                        }
                    }
                    int closeRegionWidth = (int)VASAdsMRAIDWebView.this.getResources().getDimension(R.dimen.close_region_width);
                    int closeRegionHeight = (int)VASAdsMRAIDWebView.this.getResources().getDimension(R.dimen.close_region_height);
                    if (resizeDimensions.right > maxSize.right || resizeDimensions.top < maxSize.top || resizeDimensions.top + closeRegionHeight > maxSize.bottom || resizeDimensions.right - closeRegionWidth < maxSize.left) {
                        logger.e("Resize dimensions will clip the close region which is not permitted.");
                        VASAdsMRAIDWebView.this.throwMraidError(JSBridgeMRAID.RESIZE_FAILED_MESSAGE, JSBridgeMRAID.RESIZE_MRAID_OP);
                        return;
                    }
                    int width = resizeDimensions.right - resizeDimensions.left;
                    int height = resizeDimensions.bottom - resizeDimensions.top;
                    WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(width, height, 1000, 544, -3);
                    layoutParams.gravity = 51;
                    layoutParams.x = resizeDimensions.left;
                    layoutParams.y = resizeDimensions.top;
                    VASAdsMRAIDWebView.this.setTranslationX(0.0f);
                    VASAdsMRAIDWebView.this.setTranslationY(0.0f);
                    if (TextUtils.equals((CharSequence)JSBridgeMRAID.this.currentState, (CharSequence)JSBridgeMRAID.STATE_RESIZED)) {
                        FrameLayout resizeContainer = (FrameLayout)VASAdsMRAIDWebView.this.getParent();
                        windowManager.updateViewLayout((View)resizeContainer, (ViewGroup.LayoutParams)layoutParams);
                    } else {
                        ViewUtils.removeFromParent((View)VASAdsMRAIDWebView.this);
                        FrameLayout resizeContainer = new FrameLayout(VASAdsMRAIDWebView.this.getContext());
                        FrameLayout.LayoutParams webViewLayoutParams = new FrameLayout.LayoutParams(-1, -1);
                        resizeContainer.addView((View)VASAdsMRAIDWebView.this, (ViewGroup.LayoutParams)webViewLayoutParams);
                        windowManager.addView((View)resizeContainer, (ViewGroup.LayoutParams)layoutParams);
                    }
                    VASAdsMRAIDWebView.this.closeIndicator.setVisibility(0);
                    VASAdsMRAIDWebView.this.jsBridgeMRAID.setState(JSBridgeMRAID.STATE_RESIZED);
                    VASAdsMRAIDWebView.this.getWebViewListener().resize();
                }
            });
        }

        @JavascriptInterface
        public void useCustomClose(String args) {
            logger.w("MRAID: useCustomClose is deprecated. Ignoring per spec.");
        }

        @JavascriptInterface
        public void setOrientationProperties(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: setOrientationProperties(%s)", args));
            }
            JSONObject json = new JSONObject(args);
            boolean allowOrientationChange = json.optBoolean("allowOrientationChange", true);
            String forceOrientation = json.optString("forceOrientation", "none");
            if ("none".equals(forceOrientation)) {
                int configurationOrientation = VASAdsMRAIDWebView.this.getContext().getResources().getConfiguration().orientation;
                this.requestedOrientation = allowOrientationChange ? -1 : (configurationOrientation == 2 ? 6 : 7);
            } else if ("portrait".equals(forceOrientation)) {
                this.requestedOrientation = 7;
            } else if ("landscape".equals(forceOrientation)) {
                this.requestedOrientation = 6;
            } else {
                this.throwMraidError(String.format(INVALID_ORIENTATION_MESSAGE, forceOrientation), SET_ORIENTATION_PROPERTIES_OP);
                return;
            }
            ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (VASAdsMRAIDWebView.this.interstitial || JSBridgeMRAID.this.currentState.equals(JSBridgeMRAID.STATE_EXPANDED)) {
                        Activity activity = ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this);
                        if (activity instanceof VASActivity) {
                            ((VASActivity)activity).setOrientation(JSBridgeMRAID.this.requestedOrientation);
                        } else {
                            JSBridgeMRAID.this.throwMraidError(JSBridgeMRAID.SET_ORIENTATION_FAILED_MESSAGE, JSBridgeMRAID.SET_ORIENTATION_PROPERTIES_OP);
                        }
                    }
                }
            });
        }

        @JavascriptInterface
        public void storePicture(String args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: storePicture(%s)", args));
            }
            this.throwMraidError(NOT_SUPPORTED_MESSAGE, SUPPORTS_STORE_PICTURE);
        }

        @JavascriptInterface
        public void createCalendarEvent(String args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: createCalendarEvent(%s)", args));
            }
            this.throwMraidError(NOT_SUPPORTED_MESSAGE, CREATE_CALENDAR_EVENT_MRAID_OP);
        }

        @JavascriptInterface
        public void playVideo(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("MRAID: playVideo(%s)", args));
            }
            if (VASAdsMRAIDWebView.this.hasNotBeenTouched()) {
                this.throwMraidError(AD_NOT_CLICKED_MESSAGE, PLAY_VIDEO_MRAID_OP);
                return;
            }
            JSONObject json = new JSONObject(args);
            String url = json.optString(URL_KEY, null);
            if (TextUtils.isEmpty((CharSequence)url)) {
                this.throwMraidError(NO_VIDEO_PATH_MESSAGE, PLAY_VIDEO_MRAID_OP);
                return;
            }
            MediaUtils.startVideoPlayer(VASAdsMRAIDWebView.this.getContext(), url, new MediaUtils.PlayVideoListener(){

                @Override
                public void onVideoStarted(Uri uri) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("Video activity started for <%s>", uri.toString()));
                    }
                }

                @Override
                public void onError(String message) {
                    JSBridgeMRAID.this.throwMraidError(message, JSBridgeMRAID.PLAY_VIDEO_MRAID_OP);
                }
            });
        }

        void throwMraidError(String message, String actionName) {
            logger.e(String.format("MRAID error - action: %s message: %s", actionName, message));
            VASAdsMRAIDWebView.this.callJavascript(JS_THROW_MRAID_ERROR, message, actionName);
        }

        @SuppressLint(value={"SwitchIntDef"})
        void sendPositions() {
            if (!VASAdsMRAIDWebView.this.isInjectedJSReady()) {
                return;
            }
            Activity activity = ViewUtils.getActivityForView((View)VASAdsMRAIDWebView.this);
            if (activity == null) {
                return;
            }
            EnvironmentInfo environmentInfo = new EnvironmentInfo(VASAdsMRAIDWebView.this.getContext());
            EnvironmentInfo.ScreenInfo screenInfo = environmentInfo.getDeviceInfo().getScreenInfo();
            float displayDensity = screenInfo.getDensity();
            int width = (int)((float)screenInfo.getWidth() / displayDensity);
            int height = (int)((float)screenInfo.getHeight() / displayDensity);
            WindowManager windowManager = activity.getWindowManager();
            if (windowManager == null) {
                return;
            }
            Rect maxSize = this.getMaxSize(windowManager);
            try {
                JSONObject jsonCurrentPosition = this.getJsonCurrentPosition();
                JSONObject jsonScreenSize = new JSONObject();
                jsonScreenSize.put(WIDTH_KEY, width);
                jsonScreenSize.put(HEIGHT_KEY, height);
                JSONObject jsonMaxSize = new JSONObject();
                ViewUtils.convertPixelsToDips((Context)VASAdsMRAIDWebView.this.getContext(), (Rect)maxSize);
                jsonMaxSize.put(WIDTH_KEY, maxSize.width());
                jsonMaxSize.put(HEIGHT_KEY, maxSize.height());
                int requestedOrientation = activity.getRequestedOrientation();
                boolean locked = true;
                switch (requestedOrientation) {
                    case -1: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 10: {
                        locked = false;
                    }
                }
                JSONObject json = new JSONObject();
                json.put("currentPosition", (Object)jsonCurrentPosition);
                json.put("screenSize", (Object)jsonScreenSize);
                json.put("maxSize", (Object)jsonMaxSize);
                json.put("currentAppOrientation", (Object)environmentInfo.getDeviceInfo().getConfigurationOrientation());
                json.put("orientationLocked", locked);
                VASAdsMRAIDWebView.this.callJavascript(JS_SET_POSITIONS, json);
            }
            catch (JSONException e) {
                logger.e("Error creating json object in setCurrentPosition", (Throwable)e);
            }
        }

        private Rect getMaxSize(WindowManager windowManager) {
            Rect maxSize = new Rect();
            windowManager.getDefaultDisplay().getRectSize(maxSize);
            return maxSize;
        }

        JSONObject getJsonCurrentPosition() {
            Rect dimensions = this.getDimensionsForWebView();
            ViewUtils.convertPixelsToDips((Context)VASAdsMRAIDWebView.this.getContext(), (Rect)dimensions);
            JSONObject json = new JSONObject();
            try {
                json.put("x", dimensions.left);
                json.put("y", dimensions.top);
                json.put(WIDTH_KEY, dimensions.width());
                json.put(HEIGHT_KEY, dimensions.height());
            }
            catch (JSONException e) {
                logger.e("Error creating json object", (Throwable)e);
            }
            return json;
        }

        void setReadyState() {
            if (this.ready) {
                return;
            }
            if (this.hasSize && this.viewable && this.javascriptReady) {
                this.ready = true;
                ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_PLACEMENT_TYPE, VASAdsMRAIDWebView.this.interstitial ? "interstitial" : "inline");
                        VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_SUPPORTS, JSBridgeMRAID.this.getSupportedFeatures());
                        JSBridgeMRAID.this.sendPositions();
                        VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_VIEWABLE, JSBridgeMRAID.this.viewable);
                        VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_VOLUME, VASAdsMRAIDWebView.getCurrentVolume(VASAdsMRAIDWebView.this.getContext()));
                        JSBridgeMRAID.this.sendExposureChange(((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.exposedPercentage, ((VASAdsMRAIDWebView)VASAdsMRAIDWebView.this).viewabilityWatcher.mbr);
                        EnvironmentInfo environmentInfo = new EnvironmentInfo(VASAdsMRAIDWebView.this.getContext());
                        JSBridgeMRAID.this.sendLocation(environmentInfo.getLocation());
                        JSBridgeMRAID.this.setState(VASAdsMRAIDWebView.this.getInitialState());
                    }
                });
            }
        }

        void sendLocation(Location location) {
            if (location == null || !VASAds.isLocationEnabled()) {
                VASAdsMRAIDWebView.this.callJavascript(JS_SET_LOCATION, -1);
                return;
            }
            this.lastLocation = location;
            try {
                JSONObject jsonLocation = new JSONObject();
                jsonLocation.put("lat", location.getLatitude());
                jsonLocation.put("lon", location.getLongitude());
                jsonLocation.put("type", 1);
                if (location.hasAccuracy()) {
                    jsonLocation.putOpt("accuracy", (Object)Float.valueOf(location.getAccuracy()));
                }
                jsonLocation.put("lastfix", location.getTime() / 1000L);
                VASAdsMRAIDWebView.this.callJavascript(JS_SET_LOCATION, jsonLocation);
            }
            catch (JSONException e) {
                logger.e("Error converting location to json.", (Throwable)e);
            }
        }

        @SuppressLint(value={"DefaultLocale"})
        void sendExposureChange(float exposedPercentage, Rect minimumBoundingRectangle) {
            try {
                JSONObject mbr = null;
                if (minimumBoundingRectangle != null) {
                    mbr = new JSONObject();
                    mbr.put("x", minimumBoundingRectangle.left);
                    mbr.put("y", minimumBoundingRectangle.top);
                    mbr.put(WIDTH_KEY, minimumBoundingRectangle.width());
                    mbr.put(HEIGHT_KEY, minimumBoundingRectangle.height());
                }
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d(String.format("Sending exposure change percentage: %f, minimumBoundingRectangle: %s", Float.valueOf(exposedPercentage), minimumBoundingRectangle));
                }
                VASAdsMRAIDWebView.this.callJavascript(JS_SET_EXPOSURE_CHANGE, Float.valueOf(exposedPercentage), mbr);
            }
            catch (JSONException e) {
                logger.e("Error creating minimumBoundingRectangle object for exposure change.", (Throwable)e);
            }
        }

        synchronized void setState(final String state) {
            if (!this.ready) {
                return;
            }
            this.resizing = false;
            if (!TextUtils.equals((CharSequence)state, (CharSequence)this.currentState) || TextUtils.equals((CharSequence)state, (CharSequence)STATE_RESIZED)) {
                this.currentState = state;
                ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JSONObject json = JSBridgeMRAID.this.getJsonCurrentPosition();
                        VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_STATE, state, json);
                    }
                });
            }
        }

        JSONObject getSupportedFeatures() {
            JSONObject supportedFeatures = new JSONObject();
            try {
                PackageManager packageManager = VASAdsMRAIDWebView.this.getContext().getPackageManager();
                boolean telephonyFeatureSupported = packageManager.hasSystemFeature("android.hardware.telephony");
                supportedFeatures.put(SUPPORTS_SMS, telephonyFeatureSupported);
                supportedFeatures.put(SUPPORTS_TEL, telephonyFeatureSupported);
                supportedFeatures.put(SUPPORTS_CALENDAR, false);
                supportedFeatures.put(SUPPORTS_STORE_PICTURE, false);
                supportedFeatures.put(SUPPORTS_INLINE_VIDEO, true);
                supportedFeatures.put(SUPPORTS_VPAID, false);
                boolean locationSupported = this.isLocationSupported();
                supportedFeatures.put(SUPPORTS_LOCATION, locationSupported);
            }
            catch (JSONException e) {
                logger.e("Error creating supports dictionary", (Throwable)e);
            }
            return supportedFeatures;
        }

        void setViewable(boolean viewable) {
            if (viewable != this.viewable) {
                this.viewable = viewable;
                if (this.ready) {
                    VASAdsMRAIDWebView.this.callJavascript(JS_SET_VIEWABLE, viewable);
                } else {
                    this.setReadyState();
                }
            }
        }

        void setCurrentPosition() {
            ThreadUtils.postOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSONObject jsonCurrentPosition = JSBridgeMRAID.this.getJsonCurrentPosition();
                    if (jsonCurrentPosition == null) {
                        return;
                    }
                    if (JSBridgeMRAID.this.ready) {
                        if (!JSBridgeMRAID.this.resizing) {
                            try {
                                JSONObject json = new JSONObject();
                                json.put("currentPosition", (Object)jsonCurrentPosition);
                                VASAdsMRAIDWebView.this.callJavascript(JSBridgeMRAID.JS_SET_POSITIONS, json);
                            }
                            catch (JSONException e) {
                                logger.e("Error creating json object in setCurrentPosition");
                            }
                        }
                    } else {
                        int width = jsonCurrentPosition.optInt(JSBridgeMRAID.WIDTH_KEY, 0);
                        int height = jsonCurrentPosition.optInt(JSBridgeMRAID.HEIGHT_KEY, 0);
                        if (width > 0 && height > 0) {
                            JSBridgeMRAID.this.hasSize = true;
                            JSBridgeMRAID.this.setReadyState();
                        }
                    }
                }
            });
        }

        public void onScrollChanged() {
            VASAdsMRAIDWebView.this.getLocationOnScreen(this.currentPosition);
            if (this.currentPosition[0] == this.lastPosition[0] && this.currentPosition[1] == this.lastPosition[1]) {
                return;
            }
            this.lastPosition[0] = this.currentPosition[0];
            this.lastPosition[1] = this.currentPosition[1];
            this.scrollHandler.sendEmptyMessage(1);
        }

        public void onViewableChanged(boolean viewable) {
            if (this.ready) {
                if (viewable) {
                    VASAdsMRAIDWebView.this.onResume();
                } else {
                    VASAdsMRAIDWebView.this.onPause();
                }
            }
            this.setViewable(viewable);
        }

        @Override
        public void onVolumeChange(int oldVolume, int newVolume, int maxVolume) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("onVolumeChange old = %d, new = %d, max = %d", oldVolume, newVolume, maxVolume));
            }
            float volume = (float)newVolume / (float)maxVolume * 100.0f;
            VASAdsMRAIDWebView.this.callJavascript(JS_SET_VOLUME, Float.valueOf(volume));
        }

        boolean isLocationSupported() {
            return ContextCompat.checkSelfPermission((Context)VASAdsMRAIDWebView.this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && VASAds.isLocationEnabled();
        }

        void scheduleLocationUpdate() {
            VASAdsMRAIDWebView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!JSBridgeMRAID.this.locationUpdatesEnabled) {
                        return;
                    }
                    VASAdsMRAIDWebView.this.updateLocationTask = new UpdateLocationTask(VASAdsMRAIDWebView.this.getContext(), JSBridgeMRAID.this);
                    VASAdsMRAIDWebView.this.updateLocationTask.execute(new Void[0]);
                }
            }, 5000L);
        }

        void startLocationUpdates() {
            logger.d("Starting location updates for mraid.");
            if (VASAdsMRAIDWebView.this.updateLocationTask != null) {
                VASAdsMRAIDWebView.this.updateLocationTask.cancel(true);
            }
            if (!this.isLocationSupported()) {
                logger.d("Location access is disabled. Not starting location updates.");
                return;
            }
            this.locationUpdatesEnabled = true;
            VASAdsMRAIDWebView.this.updateLocationTask = new UpdateLocationTask(VASAdsMRAIDWebView.this.getContext(), this);
            VASAdsMRAIDWebView.this.updateLocationTask.execute(new Void[0]);
        }

        void stopLocationUpdates() {
            this.locationUpdatesEnabled = false;
            if (VASAdsMRAIDWebView.this.updateLocationTask != null) {
                VASAdsMRAIDWebView.this.updateLocationTask.cancel(true);
                VASAdsMRAIDWebView.this.updateLocationTask = null;
            }
        }

        Rect getDimensionsForWebView() {
            if (STATE_RESIZED.equalsIgnoreCase(this.currentState)) {
                FrameLayout resizeContainer = (FrameLayout)VASAdsMRAIDWebView.this.getParent();
                WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)resizeContainer.getLayoutParams();
                return new Rect(layoutParams.x, layoutParams.y, layoutParams.x + layoutParams.width, layoutParams.y + layoutParams.height);
            }
            int[] outLocation = new int[2];
            VASAdsMRAIDWebView.this.getLocationInWindow(outLocation);
            return new Rect(outLocation[0], outLocation[1], outLocation[0] + VASAdsMRAIDWebView.this.getWidth(), outLocation[1] + VASAdsMRAIDWebView.this.getHeight());
        }
    }

    static class ScrollHandler
    extends Handler {
        private static final int SCROLL_UPDATE_INTERVAL = 100;
        private static final int UPDATE_POSITION = 2;
        static final int SCROLL_CHANGED = 1;
        private JSBridgeMRAID jsBridgeMRAID;

        ScrollHandler(JSBridgeMRAID jsBridgeMRAID) {
            this.jsBridgeMRAID = jsBridgeMRAID;
        }

        public void handleMessage(Message msg) {
            if (msg == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    if (this.hasMessages(2)) break;
                    this.sendEmptyMessageDelayed(2, 100L);
                    break;
                }
                case 2: {
                    this.jsBridgeMRAID.setCurrentPosition();
                    break;
                }
                default: {
                    logger.e(String.format("Unexpected msg.what = %d", msg.what));
                }
            }
        }
    }

    private static class UpdateLocationTask
    extends AsyncTask<Void, Void, Location> {
        private static final Logger logger = Logger.getInstance(UpdateLocationTask.class);
        private EnvironmentInfo environmentInfo;
        private WeakReference<JSBridgeMRAID> jsBridgeMRAIDWeakRef;

        UpdateLocationTask(Context context, JSBridgeMRAID jsBridgeMRAID) {
            this.jsBridgeMRAIDWeakRef = new WeakReference<JSBridgeMRAID>(jsBridgeMRAID);
            this.environmentInfo = new EnvironmentInfo(context);
        }

        protected Location doInBackground(Void ... voids) {
            return this.environmentInfo.getLocation();
        }

        protected void onPostExecute(Location location) {
            JSBridgeMRAID jsBridgeMRAID = (JSBridgeMRAID)this.jsBridgeMRAIDWeakRef.get();
            if (jsBridgeMRAID == null) {
                logger.d("MRAID JS Bridge is gone.");
                return;
            }
            if (!jsBridgeMRAID.isLocationSupported()) {
                jsBridgeMRAID.sendLocation(null);
                return;
            }
            if (location != null && (jsBridgeMRAID.lastLocation == null || jsBridgeMRAID.lastLocation.distanceTo(location) > 10.0f)) {
                jsBridgeMRAID.sendLocation(location);
            }
            if (!this.isCancelled()) {
                jsBridgeMRAID.scheduleLocationUpdate();
            } else {
                logger.d("Shutting down update location task.");
            }
        }
    }

    private static class ExpandParams {
        int width;
        int height;
        int orientation;
        String url;

        private ExpandParams() {
        }
    }

    private static class ResizeParams {
        int offsetX;
        int offsetY;
        int width;
        int height;
        boolean allowOffScreen;

        private ResizeParams() {
        }
    }

    public static interface VASAdsMRAIDWebViewListener
    extends VASAdsWebView.VASAdsWebViewListener {
        public void close();

        public void expand();

        public void resize();

        public void unload();
    }
}

