/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.verizon.ads.Configuration;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.support.utils.ViewUtils;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.webview.R;
import com.verizon.ads.webview.VASAdsMRAIDWebView;
import com.verizon.ads.webview.VASAdsWebView;
import java.lang.ref.WeakReference;

public final class MRAIDExpandedActivity
extends Activity {
    private static final Logger logger = Logger.getInstance(MRAIDExpandedActivity.class);
    private static final String DOMAIN = "com.verizon.ads.webview";
    private static final String CLOSE_INDICATOR_APPEARANCE_DELAY_KEY = "close.indicator.appearance.delay";
    static final String WEBVIEW_CACHED_ID = "webview_cached_id";
    static final String URL = "url";
    static final String EXPAND_WIDTH = "expand_width";
    static final String EXPAND_HEIGHT = "expand_height";
    static final String ORIENTATION = "orientation";
    static final String IMMERSIVE = "immersive";
    public static final String MRAID_EXPANDED_CLOSE_INDICATOR = "MRAID_EXPANDED_CLOSE_INDICATOR";
    public static final String TWO_PART_LOADING_SPINNER = "TWO_PART_LOADING_SPINNER";
    private RelativeLayout contentView;
    private VASAdsMRAIDWebView expandedMRAIDWebView;
    private ProgressBar loadingSpinner;
    private boolean immersive;

    protected void onCreate(Bundle savedInstanceState) {
        MutableContextWrapper mutableContextWrapper;
        super.onCreate(savedInstanceState);
        String cacheId = this.getIntent().getStringExtra(WEBVIEW_CACHED_ID);
        if (TextUtils.isEmpty((String)cacheId)) {
            logger.e(String.format("Could not find an MRAID WebView instance for cache ID: %s", cacheId));
            this.finish();
            return;
        }
        VASAdsMRAIDWebView onePartWebView = VASAdsMRAIDWebView.getCachedWebView(cacheId);
        if (onePartWebView == null) {
            logger.e(String.format("VerizonAdMRAIDWebView for cache Id <%s> was null.", cacheId));
            this.finish();
            return;
        }
        this.immersive = this.getIntent().getBooleanExtra(IMMERSIVE, true);
        Window window = this.getWindow();
        if (Build.VERSION.SDK_INT >= 19 && this.immersive) {
            this.enableImmersiveMode();
            if (window != null) {
                window.getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                    public void onSystemUiVisibilityChange(int visibility) {
                        if ((visibility & 4) == 0) {
                            MRAIDExpandedActivity.this.enableImmersiveMode();
                        }
                    }
                });
            }
        } else if (this.immersive) {
            this.requestWindowFeature(1);
            if (window != null) {
                window.setFlags(1024, 1024);
            }
        }
        this.contentView = new RelativeLayout((Context)this);
        ColorDrawable backgroundDrawable = new ColorDrawable(-16777216);
        backgroundDrawable.setAlpha(160);
        this.contentView.setBackground((Drawable)backgroundDrawable);
        this.setContentView((View)this.contentView);
        String url = this.getIntent().getStringExtra(URL);
        int width = this.getIntent().getIntExtra(EXPAND_WIDTH, -1);
        int height = this.getIntent().getIntExtra(EXPAND_HEIGHT, -1);
        RelativeLayout.LayoutParams childLayoutParams = new RelativeLayout.LayoutParams(width, height);
        childLayoutParams.addRule(13);
        if (!TextUtils.isEmpty((String)url)) {
            this.expandedMRAIDWebView = onePartWebView.getTwoPartWebView();
            mutableContextWrapper = (MutableContextWrapper)this.expandedMRAIDWebView.getContext();
            mutableContextWrapper.setBaseContext((Context)this);
            this.contentView.addView((View)this.expandedMRAIDWebView, (ViewGroup.LayoutParams)childLayoutParams);
            LoadTwoPartContentAsyncTask loadTwoPartContentAsyncTask = new LoadTwoPartContentAsyncTask(this, onePartWebView, this.expandedMRAIDWebView);
            loadTwoPartContentAsyncTask.execute(new String[]{url});
        } else {
            this.expandedMRAIDWebView = onePartWebView;
            mutableContextWrapper = (MutableContextWrapper)this.expandedMRAIDWebView.getContext();
            mutableContextWrapper.setBaseContext((Context)this);
            this.contentView.addView((View)this.expandedMRAIDWebView, (ViewGroup.LayoutParams)childLayoutParams);
            onePartWebView.setExpanded();
        }
        int orientation = this.getIntent().getIntExtra(ORIENTATION, -1);
        ViewUtils.setRequestedOrientationSafe((Activity)this, (int)orientation);
        final ImageView closeIndicator = new ImageView((Context)this);
        closeIndicator.setTag((Object)MRAID_EXPANDED_CLOSE_INDICATOR);
        closeIndicator.setImageResource(R.drawable.mraid_close);
        closeIndicator.setVisibility(8);
        closeIndicator.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MRAIDExpandedActivity.this.close();
            }
        });
        if (this.expandedMRAIDWebView.omsdkAdSession != null) {
            this.expandedMRAIDWebView.omsdkAdSession.addFriendlyObstruction((View)closeIndicator);
        }
        RelativeLayout.LayoutParams closeIndicatorLayoutParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.close_region_width), (int)this.getResources().getDimension(R.dimen.close_region_height));
        closeIndicatorLayoutParams.addRule(10);
        closeIndicatorLayoutParams.addRule(11);
        this.contentView.addView((View)closeIndicator, (ViewGroup.LayoutParams)closeIndicatorLayoutParams);
        this.contentView.postDelayed(new Runnable(){

            @Override
            public void run() {
                closeIndicator.setVisibility(0);
            }
        }, (long)Configuration.getInt((String)DOMAIN, (String)CLOSE_INDICATOR_APPEARANCE_DELAY_KEY, (int)1100));
    }

    public void onBackPressed() {
        this.close();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("onWindowFocusChanged: hasFocus = %b, immersive = %b", hasFocus, this.immersive));
        }
        if (Build.VERSION.SDK_INT >= 19 && this.immersive && hasFocus) {
            this.enableImmersiveMode();
        }
    }

    private void close() {
        if (this.expandedMRAIDWebView != null) {
            if (this.expandedMRAIDWebView.omsdkAdSession != null) {
                this.expandedMRAIDWebView.omsdkAdSession.removeAllFriendlyObstructions();
            }
            this.expandedMRAIDWebView.close();
            if (this.expandedMRAIDWebView instanceof VASAdsMRAIDWebView.TwoPartExpandWebView) {
                this.expandedMRAIDWebView.release();
            }
        } else {
            this.finish();
        }
    }

    @TargetApi(value=19)
    private void enableImmersiveMode() {
        Window window = this.getWindow();
        if (window != null) {
            View decorView = window.getDecorView();
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Enabling immersive mode:\ndecorView = %s\nActivity = %s", new Object[]{decorView, this}));
            }
            decorView.setSystemUiVisibility(5894);
        }
    }

    private void showLoadingSpinner() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MRAIDExpandedActivity.this.loadingSpinner != null) {
                    return;
                }
                MRAIDExpandedActivity.this.loadingSpinner = new ProgressBar((Context)MRAIDExpandedActivity.this);
                MRAIDExpandedActivity.this.loadingSpinner.setTag((Object)MRAIDExpandedActivity.TWO_PART_LOADING_SPINNER);
                MRAIDExpandedActivity.this.loadingSpinner.setIndeterminate(true);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                MRAIDExpandedActivity.this.loadingSpinner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                MRAIDExpandedActivity.this.contentView.addView((View)MRAIDExpandedActivity.this.loadingSpinner, (ViewGroup.LayoutParams)layoutParams);
                MRAIDExpandedActivity.this.loadingSpinner.setVisibility(0);
                MRAIDExpandedActivity.this.loadingSpinner.bringToFront();
            }
        });
    }

    private void hideLoadingSpinner() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MRAIDExpandedActivity.this.loadingSpinner.setVisibility(8);
                ViewUtils.removeFromParent((View)MRAIDExpandedActivity.this.loadingSpinner);
                MRAIDExpandedActivity.this.loadingSpinner = null;
            }
        });
    }

    private static class LoadTwoPartContentAsyncTask
    extends AsyncTask<String, Void, String> {
        private WeakReference<VASAdsMRAIDWebView> firstPartWebViewRef;
        private WeakReference<VASAdsMRAIDWebView> twoPartWebViewRef;
        private WeakReference<MRAIDExpandedActivity> mraidExpandedActivityRef;

        private LoadTwoPartContentAsyncTask(MRAIDExpandedActivity mraidExpandedActivity, VASAdsMRAIDWebView firstPartWebView, VASAdsMRAIDWebView twoPartWebView) {
            this.firstPartWebViewRef = new WeakReference<VASAdsMRAIDWebView>(firstPartWebView);
            this.twoPartWebViewRef = new WeakReference<VASAdsMRAIDWebView>(twoPartWebView);
            this.mraidExpandedActivityRef = new WeakReference<MRAIDExpandedActivity>(mraidExpandedActivity);
        }

        protected void onPreExecute() {
            MRAIDExpandedActivity mraidExpandedActivity = (MRAIDExpandedActivity)((Object)this.mraidExpandedActivityRef.get());
            if (mraidExpandedActivity != null) {
                mraidExpandedActivity.showLoadingSpinner();
            }
        }

        protected String doInBackground(String ... urls) {
            if (urls.length == 0) {
                return null;
            }
            HttpUtils.Response response = HttpUtils.getContentFromGetRequest((String)urls[0]);
            if (response != null && response.code == 200 && response.content != null) {
                return response.content;
            }
            return null;
        }

        protected void onPostExecute(String expandedContent) {
            final VASAdsMRAIDWebView firstPartWebView = (VASAdsMRAIDWebView)((Object)this.firstPartWebViewRef.get());
            VASAdsMRAIDWebView twoPartWebView = (VASAdsMRAIDWebView)((Object)this.twoPartWebViewRef.get());
            final MRAIDExpandedActivity mraidExpandedActivity = (MRAIDExpandedActivity)((Object)this.mraidExpandedActivityRef.get());
            if (firstPartWebView != null && twoPartWebView != null && mraidExpandedActivity != null) {
                if (expandedContent == null) {
                    logger.e("Failed to retrieve expanded content.");
                    twoPartWebView.throwMraidError("Unable to expand", "expand");
                    mraidExpandedActivity.finish();
                    return;
                }
                twoPartWebView.loadData(expandedContent, "text/html", "UTF-8", new VASAdsWebView.LoadDataListener(){

                    @Override
                    public void onComplete(ErrorInfo errorInfo) {
                        if (errorInfo != null) {
                            logger.e(errorInfo.toString());
                            mraidExpandedActivity.finish();
                            return;
                        }
                        firstPartWebView.setExpanded();
                        mraidExpandedActivity.hideLoadingSpinner();
                    }
                });
            } else {
                logger.d("Two Part Expandable WebView was gone.");
                if (mraidExpandedActivity != null) {
                    mraidExpandedActivity.hideLoadingSpinner();
                }
            }
        }
    }
}

