/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.verizon.ads.Logger;
import com.verizon.ads.support.utils.ActivityUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class CalendarUtils {
    private static final Logger logger = Logger.getInstance(CalendarUtils.class);
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat rruleUntilDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static final String[] DaysInWeekArray = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA", "SU"};
    private static final String[] calendarEventDateFormats = new String[]{"yyyy-MM-dd'T'HH:mmZZZ", "yyyy-MM-dd'T'HH:mm:ssZZZ"};

    public static void addEvent(Context context, JSONObject parameters, CalendarListener calendarListener) {
        if (calendarListener == null) {
            logger.e("CalendarListener is required");
            return;
        }
        String title = parameters.optString("description", null);
        String description = parameters.optString("summary", null);
        String location = parameters.optString("location", null);
        String recurrenceRule = CalendarUtils.getRecurrenceRule(parameters.optJSONObject("recurrence"));
        Date start = CalendarUtils.parseDate(parameters.optString("start", null));
        Date end = CalendarUtils.parseDate(parameters.optString("end", null));
        Integer transparency = CalendarUtils.getTransparency(parameters.optString("transparency", null));
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Creating calendar event: title: %s, location: %s, start: %s, end: %s, description: %s, rrule: %s, transparency: %s", title, location, start, end, description, recurrenceRule, transparency));
        }
        if (title == null || start == null) {
            calendarListener.onError("Description and start are required");
            return;
        }
        Intent intent = new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", title);
        intent.putExtra("beginTime", start.getTime());
        if (end != null) {
            intent.putExtra("endTime", end.getTime());
        }
        if (description != null) {
            intent.putExtra("description", description);
        }
        if (location != null) {
            intent.putExtra("eventLocation", location);
        }
        if (recurrenceRule != null) {
            intent.putExtra("rrule", recurrenceRule);
        }
        if (transparency != null) {
            intent.putExtra("availability", (Serializable)transparency);
        }
        if (ActivityUtils.startActivity((Context)context, (Intent)intent)) {
            calendarListener.onUIDisplayed();
        } else {
            calendarListener.onError("No calendar application installed");
        }
    }

    private static String getRecurrenceRule(JSONObject recurrence) {
        String daysInYear;
        String monthsInYear;
        String daysInMonth;
        ArrayList<String> byDay;
        JSONArray daysInWeek;
        if (recurrence == null) {
            return null;
        }
        StringBuilder rrule = new StringBuilder();
        String frequency = recurrence.optString("frequency", null);
        if (frequency == null) {
            logger.e("frequency is required for recurrence rule");
            return null;
        }
        rrule.append("FREQ=").append(frequency).append(';');
        Date expires = CalendarUtils.parseDate(recurrence.optString("expires", null));
        if (expires != null) {
            String until = rruleUntilDateFormat.format(expires);
            rrule.append("UNTIL=").append(until).append(';');
        }
        if ((daysInWeek = recurrence.optJSONArray("daysInWeek")) != null && (byDay = CalendarUtils.convertDaysToRRuleDays(daysInWeek)).size() > 0) {
            rrule.append("BYDAY=").append(TextUtils.join((CharSequence)",", byDay)).append(';');
        }
        if ((daysInMonth = recurrence.optString("daysInMonth", null)) != null) {
            String byMonthDay = daysInMonth.replaceAll("\\[", "").replaceAll("\\]", "");
            rrule.append("BYMONTHDAY=").append(byMonthDay).append(';');
        }
        if ((monthsInYear = recurrence.optString("monthsInYear", null)) != null) {
            String byMonth = monthsInYear.replaceAll("\\[", "").replaceAll("\\]", "");
            rrule.append("BYMONTH=").append(byMonth).append(';');
        }
        if ((daysInYear = recurrence.optString("daysInYear", null)) != null) {
            rrule.append("BYYEARDAY=").append(daysInYear).append(';');
        }
        return rrule.toString().toUpperCase();
    }

    public static Date parseDate(String value) {
        if (value == null) {
            return null;
        }
        Date date = null;
        for (String calendarEventDateFormat : calendarEventDateFormats) {
            SimpleDateFormat sdf = new SimpleDateFormat(calendarEventDateFormat);
            try {
                date = sdf.parse(value);
                if (date == null) continue;
                break;
            }
            catch (ParseException e) {
                if (!Logger.isLogLevelEnabled((int)3)) continue;
                logger.d("Parsing exception for value = " + value + " with pattern = " + calendarEventDateFormat);
            }
        }
        if (date == null) {
            logger.e("Error parsing calendar event date <" + value + ">");
        }
        return date;
    }

    private static ArrayList<String> convertDaysToRRuleDays(JSONArray intList) {
        ArrayList<String> rruleDays = new ArrayList<String>();
        for (int i = 0; i < intList.length(); ++i) {
            int day = intList.optInt(i, 0);
            if (day >= 0 && day < DaysInWeekArray.length) {
                rruleDays.add(DaysInWeekArray[day]);
                continue;
            }
            logger.e("Invalid index for day of week <" + day + ">");
        }
        return rruleDays;
    }

    private static Integer getTransparency(String value) {
        Integer result = null;
        if ("transparent".equals(value)) {
            result = 1;
        } else if ("opaque".equals(value)) {
            result = 0;
        }
        return result;
    }

    public static interface CalendarListener {
        public void onUIDisplayed();

        public void onError(String var1);
    }
}

