/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webcontroller;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.view.View;
import com.verizon.ads.AdSession;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.webview.VASAdsMRAIDWebView;
import com.verizon.ads.webview.VASAdsWebView;

public class WebController {
    private static final Logger logger = Logger.getInstance(WebController.class);
    private static final String WHO = WebController.class.getSimpleName();
    private static final HandlerThread handlerThread = new HandlerThread(WebController.class.getName());
    private static final Handler handler;
    private static final int ERROR_NO_VALID_AD = -1;
    private static final int ERROR_LOADING_VIEW = -3;
    private volatile Runnable timeoutRunnable;
    private boolean timedOut;
    private WebControllerListener listener;
    private VASAdsMRAIDWebView vasAdsMRAIDWebView;
    private String adContent;
    private boolean expanded;
    private boolean resized;

    public void setListener(WebControllerListener listener) {
        this.listener = listener;
    }

    public ErrorInfo prepare(AdSession adSession, String adContent) {
        if (TextUtils.isEmpty((CharSequence)adContent)) {
            return new ErrorInfo(WHO, "Ad content is empty.", -1);
        }
        this.adContent = adContent;
        return null;
    }

    public void load(final Context context, int timeout, final LoadListener loadListener, final boolean isInterstitial) {
        if (loadListener == null) {
            logger.e("loadListener cannot be null.");
            return;
        }
        if (context == null) {
            logger.e("context cannot be null.");
            loadListener.onComplete(new ErrorInfo(WHO, "context cannot be null.", -3));
            return;
        }
        this.startLoadTimer(timeout);
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebController.this.vasAdsMRAIDWebView = new VASAdsMRAIDWebView(context, isInterstitial, (VASAdsMRAIDWebView.VASAdsMRAIDWebViewListener)new WebControllerVASAdsMRAIDWebViewListener());
                WebController.this.vasAdsMRAIDWebView.loadData(WebController.this.adContent, null, "UTF-8", new VASAdsWebView.LoadDataListener(){

                    public void onComplete(ErrorInfo errorInfo) {
                        if (!WebController.this.timedOut) {
                            WebController.this.stopLoadTimer();
                            loadListener.onComplete(errorInfo);
                        }
                    }
                });
            }
        });
    }

    public void release() {
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebController.this.vasAdsMRAIDWebView != null) {
                    WebController.this.vasAdsMRAIDWebView.release();
                    WebController.this.vasAdsMRAIDWebView = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadTimer(long timeout) {
        WebController webController = this;
        synchronized (webController) {
            if (this.timeoutRunnable != null) {
                logger.e("Timeout timer already running");
                return;
            }
            if (timeout == 0L) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Load will timeout in %d ms", timeout));
            }
            this.timeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    WebController.this.timedOut = true;
                }
            };
            handler.postDelayed(this.timeoutRunnable, timeout);
        }
    }

    private void stopLoadTimer() {
        if (this.timeoutRunnable != null) {
            logger.d("Stopping load timer");
            handler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    public boolean isResized() {
        return this.resized;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void fireImpression() {
        if (this.vasAdsMRAIDWebView != null) {
            this.vasAdsMRAIDWebView.fireImpression();
        }
    }

    public void setImmersiveEnabled(boolean immersive) {
        if (this.vasAdsMRAIDWebView != null) {
            this.vasAdsMRAIDWebView.setImmersive(immersive);
        }
    }

    public View getVASAdsMRAIDWebView() {
        return this.vasAdsMRAIDWebView;
    }

    static {
        handlerThread.start();
        handler = new Handler(handlerThread.getLooper());
    }

    public static interface LoadListener {
        public void onComplete(ErrorInfo var1);
    }

    public static interface WebControllerListener {
        public void onClicked();

        public void onAdLeftApplication();

        public void close();

        public void onError(ErrorInfo var1);

        public void expand();

        public void resize();

        public void unload();
    }

    private class WebControllerVASAdsMRAIDWebViewListener
    implements VASAdsMRAIDWebView.VASAdsMRAIDWebViewListener {
        private WebControllerVASAdsMRAIDWebViewListener() {
        }

        public void close() {
            WebController.this.expanded = false;
            WebController.this.resized = false;
            if (WebController.this.listener != null) {
                WebController.this.listener.close();
            }
        }

        public void expand() {
            WebController.this.expanded = true;
            if (WebController.this.listener != null) {
                WebController.this.listener.expand();
            }
        }

        public void resize() {
            WebController.this.resized = true;
            if (WebController.this.listener != null) {
                WebController.this.listener.resize();
            }
        }

        public void unload() {
            if (WebController.this.listener != null) {
                WebController.this.listener.unload();
            }
        }

        public void onError(ErrorInfo errorInfo) {
            if (WebController.this.listener != null) {
                WebController.this.listener.onError(errorInfo);
            }
        }

        public void onAdLeftApplication(VASAdsWebView vasAdsWebView) {
            if (WebController.this.listener != null) {
                WebController.this.listener.onAdLeftApplication();
            }
        }

        public void onClicked(VASAdsWebView vasAdsWebView) {
            if (WebController.this.listener != null) {
                WebController.this.listener.onClicked();
            }
        }
    }
}

