/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.text.TextUtils;
import com.verizon.ads.Logger;
import com.verizon.ads.utils.ThreadUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TimedMemoryCache<O> {
    private static final Logger logger = Logger.getInstance(TimedMemoryCache.class);
    private static final long CACHE_TIMEOUT = 60000L;
    private static final long FORCE_REMOVE_TIME = -1L;
    private static long cleanerDelay = 10000L;
    private final Map<String, CacheItem> cache = new ConcurrentHashMap<String, CacheItem>();
    private final AtomicInteger lastCacheId = new AtomicInteger(0);
    private final AtomicBoolean cleanerRunning = new AtomicBoolean();

    public static void setCleanerDelay(long delay) {
        cleanerDelay = delay;
    }

    public String add(O objectToCache, Long timeout) {
        return this.add(null, objectToCache, timeout);
    }

    public String add(String key, O objectToCache, Long timeout) {
        CacheItem currentItem;
        if (objectToCache == null) {
            logger.e("Nothing to cache, object provided is null");
            return null;
        }
        String tmpKey = key;
        if (TextUtils.isEmpty((CharSequence)tmpKey)) {
            tmpKey = String.valueOf(this.lastCacheId.incrementAndGet());
        }
        if ((currentItem = this.cache.get(tmpKey)) != null) {
            this.onOverwritten(tmpKey, currentItem.cachedObject);
        }
        CacheItem<O> cacheItem = new CacheItem<O>(objectToCache, timeout);
        this.cache.put(tmpKey, cacheItem);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Add CacheItem\n\tID: " + tmpKey + "\n\tItem: " + cacheItem);
        }
        this.startCleaner();
        return tmpKey;
    }

    public O get(String cacheId) {
        CacheItem cachedItem = this.getCachedItem(cacheId);
        if (cachedItem == null) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("No item in cache for ID <" + cacheId + ">");
            }
            return null;
        }
        this.cache.remove(cacheId);
        return (O)cachedItem.cachedObject;
    }

    private CacheItem getCachedItem(String cacheId) {
        if (cacheId == null) {
            return null;
        }
        CacheItem cachedItem = this.cache.get(cacheId);
        if (cachedItem == null) {
            this.cache.remove(cacheId);
            return null;
        }
        if (this.removeItemIfExpired(cacheId, cachedItem, System.currentTimeMillis())) {
            return null;
        }
        return cachedItem;
    }

    public boolean containsKey(String cacheId) {
        return this.cache.containsKey(cacheId);
    }

    private void startCleaner() {
        if (!this.cleanerRunning.compareAndSet(false, true)) {
            logger.d("Cleaner already running");
            return;
        }
        ThreadUtils.runOnWorkerThread((Runnable)new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(cleanerDelay);
                    }
                    catch (InterruptedException e) {
                        logger.e("Error occurred while cleaner was sleeping", (Throwable)e);
                        break;
                    }
                    long currentTime = System.currentTimeMillis();
                    TimedMemoryCache.this.runCleaner(currentTime);
                } while (TimedMemoryCache.this.cache.size() > 0);
                logger.d("Stopping cleaner");
                TimedMemoryCache.this.cleanerRunning.set(false);
            }
        });
    }

    private void runCleaner(long currentTime) {
        for (Map.Entry<String, CacheItem> cacheEntry : this.cache.entrySet()) {
            String cacheId = cacheEntry.getKey();
            CacheItem cachedItem = cacheEntry.getValue();
            if (cachedItem == null) {
                if (!Logger.isLogLevelEnabled((int)3)) continue;
                logger.d("Attempted to remove CacheItem with ID <" + cacheId + "> but item was null");
                continue;
            }
            this.removeItemIfExpired(cacheId, cachedItem, currentTime);
        }
    }

    public void expireAll() {
        this.runCleaner(-1L);
    }

    private boolean removeItemIfExpired(String cacheId, CacheItem cacheItem, long currentTime) {
        if (currentTime > cacheItem.itemTimeout || currentTime == -1L) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Removed CacheItem\n\t:Checked time: " + currentTime + "\n\tID: " + cacheId + "\n\tItem: " + cacheItem);
            }
            this.cache.remove(cacheId);
            this.onExpired(cacheId, cacheItem.cachedObject);
            return true;
        }
        return false;
    }

    protected void onExpired(String key, O cachedObject) {
    }

    protected void onOverwritten(String key, O cachedObject) {
    }

    private static class CacheItem<T> {
        T cachedObject;
        long itemTimeout;

        CacheItem(T cachedObject, Long timeout) {
            Long tmpTimeout = timeout;
            if (tmpTimeout == null) {
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d("Cached item timeout is null, setting to default: 60000");
                }
                tmpTimeout = 60000L;
            }
            this.cachedObject = cachedObject;
            this.itemTimeout = System.currentTimeMillis() + tmpTimeout;
        }

        public String toString() {
            return "CacheItem{cachedObject=" + this.cachedObject + ", itemTimeout=" + this.itemTimeout + '}';
        }
    }
}

