/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.browser.customtabs.CustomTabsIntent;
import com.verizon.ads.Logger;

public class ActivityUtils {
    private static final Logger logger = Logger.getInstance(ActivityUtils.class);

    public static boolean startActivity(Context context, Intent intent) {
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            logger.e("Unable to start activity for intent", (Throwable)e);
            return false;
        }
    }

    public static boolean startActivityFromUrl(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e("Unable to start activity for null url");
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        return ActivityUtils.startActivity(context, intent);
    }

    public static boolean isActivityContext(Context context) {
        if (context == null) {
            return false;
        }
        if (context instanceof Activity) {
            return true;
        }
        Context tmpContext = context;
        while (tmpContext instanceof ContextWrapper) {
            if (!((tmpContext = ((ContextWrapper)tmpContext).getBaseContext()) instanceof Activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean startCustomTabActivityFromUrl(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e("Unable to start custom tab activity for null or empty url");
            return false;
        }
        if (context == null) {
            logger.e("Unable to start custom tab activity for null context");
            return false;
        }
        try {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            if (!(context instanceof Activity)) {
                customTabsIntent.intent.addFlags(0x10000000);
            }
            customTabsIntent.launchUrl(context, Uri.parse((String)url));
        }
        catch (Throwable e) {
            logger.e("Error launching custom tab activity.", e);
            return false;
        }
        return true;
    }
}

