/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.content.Context;
import com.verizon.ads.Configuration;
import com.verizon.ads.Logger;
import com.verizon.ads.WaterfallProvider;

public class WaterfallProviderFactory {
    private static final Logger logger = Logger.getInstance(WaterfallProviderFactory.class);
    private static final String VERIZON_ADS_DOMAIN = "com.verizon.ads";
    private static final String WATERFALL_PROVIDER_CLASS_KEY = "waterfallProviderClass";

    public static WaterfallProvider getInstance(Context context, String defaultWaterfallProviderClassName) {
        String waterfallProviderClassName = Configuration.getString((String)VERIZON_ADS_DOMAIN, (String)WATERFALL_PROVIDER_CLASS_KEY, (String)defaultWaterfallProviderClassName);
        return WaterfallProviderFactory.createWaterfallProviderInstance(context, waterfallProviderClassName);
    }

    private static WaterfallProvider createWaterfallProviderInstance(Context context, String waterfallProviderClassName) {
        WaterfallProvider waterfallProvider = null;
        try {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Creating WaterfallProvider instance for class: %s", waterfallProviderClassName));
            }
            waterfallProvider = Class.forName(waterfallProviderClassName).asSubclass(WaterfallProvider.class).getDeclaredConstructor(Context.class).newInstance(context);
        }
        catch (Throwable t) {
            logger.e(String.format("Error creating WaterfallProvider instance for class: %s", waterfallProviderClassName), t);
        }
        return waterfallProvider;
    }
}

