/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support.utils;

import android.app.Activity;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.Logger;
import java.util.Locale;

public class ViewUtils {
    private static final Logger logger = Logger.getInstance(ViewUtils.class);
    private static final float DENSITY_NOT_SET = -1.0f;
    private static volatile float density = -1.0f;

    public static void attachView(ViewGroup parent, View child) {
        ViewUtils.attachView(parent, child, null);
    }

    public static void attachView(ViewGroup parent, View child, ViewGroup.LayoutParams layoutParams) {
        Context parentContext;
        Context childContext;
        if (child.getParent() != null) {
            ViewUtils.removeFromParent(child);
        }
        if ((childContext = child.getContext()) instanceof MutableContextWrapper && childContext != (parentContext = parent.getContext())) {
            logger.d("Changing view context to match parent context");
            ((MutableContextWrapper)childContext).setBaseContext(parentContext);
        }
        if (layoutParams != null) {
            parent.addView(child, layoutParams);
        } else {
            parent.addView(child);
        }
    }

    public static void removeFromParent(View view) {
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof ViewGroup)) {
            logger.d("Unable to remove view from parent, no valid parent view found");
            return;
        }
        ((ViewGroup)viewParent).removeView(view);
    }

    public static int getActivityHashForView(View view) {
        int activityHash = -1;
        Activity activity = ViewUtils.getActivityForView(view);
        if (activity == null) {
            logger.e("Unable to get activity hash");
        } else {
            activityHash = activity.hashCode();
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format(Locale.getDefault(), "Found activity hash code <%d> for view <%s>", activityHash, view.toString()));
        }
        return activityHash;
    }

    public static Activity getActivityForView(View view) {
        Activity activity = null;
        if (view != null) {
            Context context = view.getContext();
            while (context instanceof MutableContextWrapper) {
                context = ((MutableContextWrapper)context).getBaseContext();
            }
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Found activity <%s> for view <%s>", activity, view));
        }
        return activity;
    }

    public static int convertPixelsToDips(Context context, int pixels) {
        if (density == -1.0f) {
            density = new EnvironmentInfo(context).getDeviceInfo().getScreenInfo().getDensity();
        }
        return (int)((float)pixels / density);
    }

    public static int convertDipsToPixels(Context context, int dips) {
        return (int)Math.ceil(TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)context.getResources().getDisplayMetrics()));
    }

    public static void convertPixelsToDips(Context context, Rect dimensions) {
        if (dimensions == null) {
            logger.e("Unable to convert for null dimensions");
            return;
        }
        if (density == -1.0f) {
            density = new EnvironmentInfo(context).getDeviceInfo().getScreenInfo().getDensity();
        }
        int width = (int)((float)(dimensions.right - dimensions.left) / density);
        int height = (int)((float)(dimensions.bottom - dimensions.top) / density);
        dimensions.left = (int)((float)dimensions.left / density);
        dimensions.top = (int)((float)dimensions.top / density);
        dimensions.right = dimensions.left + width;
        dimensions.bottom = dimensions.top + height;
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Converted dimensions from pixels to dips: %s", dimensions.flattenToString()));
        }
    }

    public static Rect getViewDimensionsRelativeToContent(View view, Rect dimensions) {
        if ((dimensions = ViewUtils.getViewDimensionsOnScreen(view, dimensions)) != null) {
            ViewGroup rootView = ViewUtils.getDecorView(view);
            if (rootView == null) {
                logger.e("Unable to calculate dimensions for null root view");
                return null;
            }
            Rect contentRect = new Rect();
            rootView.getWindowVisibleDisplayFrame(contentRect);
            dimensions.top -= contentRect.top;
            dimensions.bottom -= contentRect.top;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Dimensions relative to content for View <%s>: %s", view, dimensions != null ? dimensions.flattenToString() : "null"));
        }
        return dimensions;
    }

    public static Rect getViewDimensionsOnScreen(View view, Rect dimensions) {
        if (view == null) {
            logger.e("Unable to calculate view dimensions for null view");
            return null;
        }
        if (dimensions == null) {
            dimensions = new Rect();
        }
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        dimensions.left = location[0];
        dimensions.top = location[1];
        dimensions.right = dimensions.left + view.getWidth();
        dimensions.bottom = dimensions.top + view.getHeight();
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("On screen dimensions for View <%s>: %s", view, dimensions.flattenToString()));
        }
        return dimensions;
    }

    public static ViewGroup getDecorView(View view) {
        ViewGroup decorView = null;
        View tempDecorView = null;
        Window window = null;
        Activity activity = ViewUtils.getActivityForView(view);
        if (activity != null) {
            window = activity.getWindow();
        }
        if (window != null) {
            tempDecorView = window.getDecorView();
        } else if (view != null) {
            tempDecorView = view.getRootView();
        }
        if (tempDecorView instanceof ViewGroup) {
            decorView = (ViewGroup)tempDecorView;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Found decor view <%s> for view <%s>", decorView, view));
        }
        return decorView;
    }

    public static Rect getContentDimensions(View view, Rect dimensions) {
        if (view == null) {
            logger.e("Unable to calculate content dimensions for null view");
            return null;
        }
        ViewGroup rootView = ViewUtils.getDecorView(view);
        if (rootView == null) {
            logger.e("Unable to calculate content for null root view");
            return null;
        }
        if (dimensions == null) {
            dimensions = new Rect();
        }
        rootView.getWindowVisibleDisplayFrame(dimensions);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Content dimensions for View <%s>: %s", view, dimensions.flattenToString()));
        }
        return dimensions;
    }

    public static void setRequestedOrientationSafe(Activity activity, int requestedOrientation) {
        try {
            activity.setRequestedOrientation(requestedOrientation);
        }
        catch (IllegalStateException e) {
            logger.w("Orientation not changed due to android issue: https://issuetracker.google.com/issues/68454482", (Throwable)e);
        }
    }
}

