/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.SuppressLint;
import com.verizon.ads.Logger;
import com.verizon.ads.support.Cache;
import java.util.ArrayList;
import java.util.List;

public class SimpleCache<T>
implements Cache<T> {
    private static final Logger logger = Logger.getInstance(SimpleCache.class);
    private final List<T> cache;

    public SimpleCache() {
        logger.d("Creating simple cache");
        this.cache = new ArrayList<T>();
    }

    @Override
    public synchronized void add(T item) {
        if (item == null) {
            logger.e("Cannot add a null item to the cache");
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Adding item to cache: %s", item));
        }
        this.cache.add(item);
    }

    @Override
    public synchronized T remove() {
        if (this.cache.size() == 0) {
            return null;
        }
        T item = this.cache.remove(0);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Removing item from cache: %s", item));
        }
        return item;
    }

    @Override
    public synchronized int size() {
        return this.cache.size();
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public synchronized void trim(Cache.TrimStrategy trimStrategy, int maxSize) {
        if (maxSize < 0) {
            logger.e("The maximum cache size must be greater than or equal to zero");
            return;
        }
        int numItemsToRemove = this.cache.size() - maxSize;
        if (numItemsToRemove <= 0) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Current cache size of %d is less than maximum cache size of %d -- no items to trim", this.cache.size(), maxSize));
            }
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Trimming %d item(s) from the cache", numItemsToRemove));
        }
        if (trimStrategy == SimpleCacheTrimStrategy.TRIM_FROM_FRONT) {
            this.cache.subList(0, numItemsToRemove).clear();
        } else if (trimStrategy == SimpleCacheTrimStrategy.TRIM_FROM_BACK) {
            this.cache.subList(this.cache.size() - numItemsToRemove, this.cache.size()).clear();
        } else {
            logger.e(String.format("Unknown trim strategy: %s", trimStrategy));
        }
    }

    public static enum SimpleCacheTrimStrategy implements Cache.TrimStrategy
    {
        TRIM_FROM_FRONT,
        TRIM_FROM_BACK;

    }
}

