/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.verizon.ads.Logger;
import com.verizon.ads.support.TimedMemoryCache;
import com.verizon.ads.support.utils.ActivityUtils;
import com.verizon.ads.support.utils.ViewUtils;

public abstract class VASActivity
extends Activity {
    private static final Logger logger = Logger.getInstance(VASActivity.class);
    private static final String ACTIVITY_CONFIG_ID_KEY = "activity_config_id";
    private static final long ON_CREATE_TIMEOUT = 5000L;
    private static TimedMemoryCache<VASActivityConfig> timedMemoryCache = new TimedMemoryCache();
    private boolean activityIsLaunching = true;
    protected VASActivityConfig activityConfig;
    protected ViewGroup rootView;

    protected static void launch(Context context, Class<? extends VASActivity> clazz, VASActivityConfig activityConfig) {
        String activityConfigCacheId;
        VASActivityConfig tmpActivityConfig = activityConfig;
        if (tmpActivityConfig == null) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("No VASActivity Configuration specified, creating default activity Configuration.");
            }
            tmpActivityConfig = new VASActivityConfig();
        }
        if ((activityConfigCacheId = timedMemoryCache.add(tmpActivityConfig, 5000L)) == null) {
            logger.e("Unable to launch VASActivity, failed to cache activity state");
            return;
        }
        Intent intent = new Intent(context, clazz);
        intent.putExtra(ACTIVITY_CONFIG_ID_KEY, activityConfigCacheId);
        if (!ActivityUtils.isActivityContext(context)) {
            intent.addFlags(0x10000000);
        }
        if (tmpActivityConfig.enterAnimationId != 0 || tmpActivityConfig.exitAnimationId != 0) {
            context.startActivity(intent, ActivityOptions.makeCustomAnimation((Context)context, (int)tmpActivityConfig.enterAnimationId, (int)tmpActivityConfig.exitAnimationId).toBundle());
        } else {
            context.startActivity(intent);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.loadActivityConfig()) {
            logger.e("Failed to load activity config, aborting activity launch <" + (Object)((Object)this) + ">");
            this.finish();
            return;
        }
        logger.d("New activity created");
        if (this.activityConfig.audioSource != -1) {
            this.setVolumeControlStream(this.activityConfig.audioSource);
        }
        if (Build.VERSION.SDK_INT >= 19 && this.activityConfig.immersive) {
            this.enableImmersiveMode();
            this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 4) == 0) {
                        VASActivity.this.enableImmersiveMode();
                    }
                }
            });
        } else if (this.activityConfig.immersive) {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
        }
        if (this.activityIsLaunching && this.getRequestedOrientation() != this.activityConfig.orientation) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Setting requested orientation on activity:\n\tCurrent requested orientation: " + this.getRequestedOrientation() + "\n\tDesired requested orientation: " + this.activityConfig.orientation);
            }
            ViewUtils.setRequestedOrientationSafe(this, this.activityConfig.orientation);
        }
        this.activityIsLaunching = false;
    }

    @TargetApi(value=19)
    private void enableImmersiveMode() {
        View decorView = this.getWindow().getDecorView();
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Enabling immersive mode:\ndecorView = " + decorView + "\nActivity = " + (Object)((Object)this));
        }
        decorView.setSystemUiVisibility(5894);
    }

    public void setOrientation(int orientation) {
        if (orientation != this.getRequestedOrientation()) {
            this.activityConfig.orientation = orientation;
            ViewUtils.setRequestedOrientationSafe(this, orientation);
        }
    }

    public void onDestroy() {
        if (this.activityConfig != null && !this.isFinishing() && !this.saveActivityState()) {
            logger.e("Failed to save activity state <" + (Object)((Object)this) + ">");
        }
        super.onDestroy();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("onWindowFocusChanged: hasFocus = " + hasFocus);
            if (this.activityConfig != null) {
                logger.d("activityConfig.immersive = " + this.activityConfig.immersive);
            }
        }
        if (Build.VERSION.SDK_INT >= 19 && this.activityConfig != null && this.activityConfig.immersive && hasFocus) {
            this.enableImmersiveMode();
        }
    }

    public void finish() {
        if (this.activityConfig != null) {
            this.overridePendingTransition(this.activityConfig.enterAnimationId, this.activityConfig.exitAnimationId);
        }
        super.finish();
    }

    private boolean loadActivityConfig() {
        Intent launchIntent = this.getIntent();
        String activityConfigCacheId = launchIntent.getStringExtra(ACTIVITY_CONFIG_ID_KEY);
        VASActivityConfig cachedItem = timedMemoryCache.get(activityConfigCacheId);
        if (cachedItem == null) {
            return false;
        }
        this.activityConfig = cachedItem;
        return true;
    }

    private boolean saveActivityState() {
        Intent intent = this.getIntent();
        intent.removeExtra(ACTIVITY_CONFIG_ID_KEY);
        String activityConfigCacheId = timedMemoryCache.add(this.activityConfig, null);
        if (activityConfigCacheId == null) {
            return false;
        }
        intent.putExtra(ACTIVITY_CONFIG_ID_KEY, activityConfigCacheId);
        return true;
    }

    public static class VASActivityConfig {
        private boolean immersive;
        private boolean transparent;
        private int orientation = -1;
        private int audioSource = -1;
        private int enterAnimationId = 0;
        private int exitAnimationId = 0;

        public VASActivityConfig setImmersive(boolean immersive) {
            this.immersive = immersive;
            return this;
        }

        public VASActivityConfig setOrientation(int orientation) {
            this.orientation = orientation;
            return this;
        }

        public VASActivityConfig setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        public VASActivityConfig setTransitionAnimation(int enterAnimationId, int exitAnimationId) {
            this.enterAnimationId = enterAnimationId;
            this.exitAnimationId = exitAnimationId;
            return this;
        }

        public VASActivityConfig setTransparent(boolean transparent) {
            this.transparent = transparent;
            return this;
        }
    }
}

