/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.interstitialwebadapter;

import android.content.Context;
import com.verizon.ads.AdContent;
import com.verizon.ads.ContentFilter;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.interstitialplacement.InterstitialAd;
import com.verizon.ads.interstitialwebadapter.InterstitialWebAdapter;
import com.verizon.ads.utils.TextUtils;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class InterstitialWebAdapterPlugin
extends Plugin {
    private static final Logger logger = Logger.getInstance(InterstitialWebAdapterPlugin.class);
    private static final String PLUGIN_ID = "com.verizon.ads.interstitialwebadapter";
    private static final String PLUGIN_NAME = "Interstitial Web Adapter";
    private static final String PLUGIN_VERSION = "1.2.0-4dde96a";
    private static final String PLUGIN_AUTHOR = "Verizon";
    private static final URI PLUGIN_EMAIL = null;
    private static final URL PLUGIN_WEBSITE = null;
    private static final int PLUGIN_MIN_API_LEVEL = 1;
    private static final Pattern PATTERN_HTML = Pattern.compile("<HTML", 2);
    private static final Pattern PATTERN_HEAD_OR_BODY = Pattern.compile("<HEAD|<BODY", 2);
    private static final Pattern PATTERN_OTHER_HTML_TAGS = Pattern.compile("<(SCRIPT|IMG|IFRAME|A|DIV|SPAN|P|H[1-6])[ />]", 2);

    public InterstitialWebAdapterPlugin(Context applicationContext) {
        super(applicationContext, PLUGIN_ID, PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR, PLUGIN_EMAIL, PLUGIN_WEBSITE, 1);
    }

    protected boolean prepare() {
        logger.d("Preparing InterstitialWebAdapterPlugin");
        this.registerAdAdapter(InterstitialAd.class, InterstitialWebAdapter.class, new InterstitialWebContentFilter());
        return true;
    }

    protected void onPluginEnabled() {
    }

    protected void onPluginDisabled() {
    }

    static class InterstitialWebContentFilter
    implements ContentFilter {
        InterstitialWebContentFilter() {
        }

        public boolean accepts(AdContent adContent) {
            if (adContent == null) {
                return false;
            }
            String content = adContent.getContent();
            if (TextUtils.isEmpty((String)content)) {
                return false;
            }
            try {
                new JSONObject(content);
                return false;
            }
            catch (JSONException jSONException) {
                Matcher matcher = PATTERN_HEAD_OR_BODY.matcher(content);
                if (matcher.find()) {
                    return true;
                }
                matcher.usePattern(PATTERN_HTML);
                if (matcher.find()) {
                    return false;
                }
                matcher.usePattern(PATTERN_OTHER_HTML_TAGS);
                return matcher.find();
            }
        }
    }
}

