/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.util.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class ClientHttpRequest
extends Observable {
    URLConnection connection;
    OutputStream os = null;
    Map<String, String> cookies = new HashMap<String, String>();
    String rawCookies = "";
    private static SecureRandom random = new SecureRandom();
    String boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();
    private boolean isCanceled = false;
    private int bytesSent = 0;

    public ClientHttpRequest(URLConnection connection) throws IOException {
        this.connection = connection;
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL url) throws IOException {
        this(url.openConnection());
    }

    public ClientHttpRequest(URL url, Proxy proxy) throws IOException {
        this(url.openConnection(proxy));
    }

    public ClientHttpRequest(String urlString) throws IOException {
        this(new URL(urlString));
    }

    protected void connect() throws IOException {
        if (this.os == null) {
            this.os = this.connection.getOutputStream();
        }
    }

    protected void write(char c) throws IOException {
        this.connect();
        this.os.write(c);
    }

    protected void write(String s) throws IOException {
        this.connect();
        this.os.write(s.getBytes());
    }

    protected long newlineNumBytes() {
        return 2L;
    }

    protected void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    protected void writeln(String s) throws IOException {
        this.connect();
        this.write(s);
        this.newline();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private long boundaryNumBytes() {
        return this.boundary.length() + 2;
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    private void postCookies() {
        StringBuffer cookieList = new StringBuffer(this.rawCookies);
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            if (cookieList.length() > 0) {
                cookieList.append("; ");
            }
            cookieList.append(String.valueOf(cookie.getKey()) + "=" + cookie.getValue());
        }
        if (cookieList.length() > 0) {
            this.connection.setRequestProperty("Cookie", cookieList.toString());
        }
    }

    public void setCookies(String rawCookies) throws IOException {
        this.rawCookies = rawCookies == null ? "" : rawCookies;
        this.cookies.clear();
    }

    public void setCookie(String name, String value) throws IOException {
        this.cookies.put(name, value);
    }

    public void setCookies(Map cookies) throws IOException {
        if (cookies != null) {
            this.cookies.putAll(cookies);
        }
    }

    public void setCookies(String[] cookies) throws IOException {
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length - 1) {
                this.setCookie(cookies[i], cookies[i + 1]);
                i += 2;
            }
        }
    }

    private long writeNameNumBytes(String name) {
        return this.newlineNumBytes() + (long)"Content-Disposition: form-data; name=\"".length() + (long)name.getBytes().length + 1L;
    }

    private void writeName(String name) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write('\"');
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pipe(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        this.bytesSent = 0;
        this.isCanceled = false;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, nread);
                this.bytesSent += nread;
                if (this.isCanceled) {
                    throw new IOException("Canceled");
                }
                out.flush();
                this.setChanged();
                this.notifyObservers(this.bytesSent);
                this.clearChanged();
            }
        }
        out.flush();
        buf = null;
    }

    public void setParameter(String name, String value) throws IOException {
        this.boundary();
        this.writeName(name);
        this.newline();
        this.newline();
        this.writeln(value);
    }

    public void setParameter(String name, String filename, InputStream is) throws IOException {
        this.boundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.writeln(type);
        this.newline();
        this.pipe(is, this.os);
        this.newline();
    }

    public long getFilePostSize(String name, File file) {
        String filename = file.getPath();
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        return this.boundaryNumBytes() + this.writeNameNumBytes(name) + (long)"; filename=\"".length() + (long)filename.getBytes().length + 1L + this.newlineNumBytes() + (long)"Content-Type: ".length() + (long)type.length() + this.newlineNumBytes() + this.newlineNumBytes() + file.length() + this.newlineNumBytes();
    }

    public void setParameter(String name, File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            this.setParameter(name, file.getPath(), fis);
        }
    }

    public void setParameter(Object name, Object object) throws IOException {
        if (object instanceof File) {
            this.setParameter(name.toString(), (File)object);
        } else {
            this.setParameter(name.toString(), object.toString());
        }
    }

    public void setParameters(Map parameters) throws IOException {
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                this.setParameter((Object)entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public void setParameters(Object ... parameters) throws IOException {
        int i = 0;
        while (i < parameters.length - 1) {
            this.setParameter((Object)parameters[i].toString(), parameters[i + 1]);
            i += 2;
        }
    }

    public long getPostFooterSize() {
        return this.boundaryNumBytes() + 2L + this.newlineNumBytes() + this.newlineNumBytes();
    }

    private InputStream doPost() throws IOException {
        this.boundary();
        this.writeln("--");
        this.os.close();
        return this.connection.getInputStream();
    }

    public InputStream post() throws IOException {
        this.postCookies();
        return this.doPost();
    }

    public InputStream post(Map parameters) throws IOException {
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(Object ... parameters) throws IOException {
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(Map cookies, Map parameters) throws IOException {
        this.setCookies(cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(String raw_cookies, Map parameters) throws IOException {
        this.setCookies(raw_cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(String[] cookies, Object[] parameters) throws IOException {
        this.setCookies(cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public static InputStream post(URL url, Map parameters) throws IOException {
        return new ClientHttpRequest(url).post(parameters);
    }

    public static InputStream post(URLConnection connection, Map parameters) throws IOException {
        return new ClientHttpRequest(connection).post(parameters);
    }

    public static InputStream post(URL url, Object[] parameters) throws IOException {
        return new ClientHttpRequest(url).post(parameters);
    }

    public static InputStream post(URL url, Map cookies, Map parameters) throws IOException {
        return new ClientHttpRequest(url).post(cookies, parameters);
    }

    public static InputStream post(URL url, String[] cookies, Object[] parameters) throws IOException {
        return new ClientHttpRequest(url).post(cookies, parameters);
    }

    public URLConnection getConnection() {
        return this.connection;
    }
}

