/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.util.http.HttpUtility;
import java.io.IOException;
import java.util.HashMap;

public final class ResultsAPIWrapper
extends AbstractAPIWrapper {
    private static final String DETAILED_REPORT_URI = "https://analysiscenter.veracode.com/api/2.0/detailedreport.do";
    private static final String DETAILED_REPORT_PDF_URI = "https://analysiscenter.veracode.com/api/2.0/detailedreportpdf.do";
    private static final String GET_APP_BUILDS_URI = "https://analysiscenter.veracode.com/api/2.0/getappbuilds.do";
    private static final String GET_CALL_STACKS_URI = "https://analysiscenter.veracode.com/api/2.0/getcallstacks.do";
    private static final String SUMMARY_REPORT_URI = "https://analysiscenter.veracode.com/api/2.0/summaryreport.do";
    private static final String SUMMARY_REPORT_PDF_URI = "https://analysiscenter.veracode.com/api/2.0/summaryreportpdf.do";
    private static final String THIRD_PARTY_REPORT_PDF_URI = "https://analysiscenter.veracode.com/api/2.0/thirdpartyreportpdf.do";

    public String detailedReport(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadDataString(DETAILED_REPORT_URI);
    }

    public byte[] detailedReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(DETAILED_REPORT_PDF_URI);
    }

    public String getAppBuilds() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_BUILDS_URI);
    }

    public String getCallStacks(String build_id, String flaw_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (flaw_id != null) {
            queryString.put("flaw_id", HttpUtility.urlEncode(flaw_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_CALL_STACKS_URI);
    }

    public String summaryReport(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadDataString(SUMMARY_REPORT_URI);
    }

    public byte[] summaryReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(SUMMARY_REPORT_PDF_URI);
    }

    public byte[] thirdPartyReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(THIRD_PARTY_REPORT_PDF_URI);
    }
}

