/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.util.http.HttpUtility;
import java.io.IOException;
import java.util.HashMap;

public final class AdminAPIWrapper
extends AbstractAPIWrapper {
    private static final String CREATE_TEAM_URI = "https://analysiscenter.veracode.com/api/3.0/createteam.do";
    private static final String CREATE_USER_URI = "https://analysiscenter.veracode.com/api/3.0/createuser.do";
    private static final String DELETE_TEAM_URI = "https://analysiscenter.veracode.com/api/3.0/deleteteam.do";
    private static final String DELETE_USER_URI = "https://analysiscenter.veracode.com/api/3.0/deleteuser.do";
    private static final String GET_CURRICULUM_LIST_URI = "https://analysiscenter.veracode.com/api/3.0/getcurriculumlist.do";
    private static final String GET_TEAM_LIST_URI = "https://analysiscenter.veracode.com/api/3.0/getteamlist.do";
    private static final String GET_TRACK_LIST_URI = "https://analysiscenter.veracode.com/api/3.0/gettracklist.do";
    private static final String GET_USER_INFO_URI = "https://analysiscenter.veracode.com/api/3.0/getuserinfo.do";
    private static final String GET_USER_LIST_URI = "https://analysiscenter.veracode.com/api/3.0/getuserlist.do";
    private static final String UPDATE_TEAM_URI = "https://analysiscenter.veracode.com/api/3.0/updateteam.do";
    private static final String UPDATE_USER_URI = "https://analysiscenter.veracode.com/api/3.0/updateuser.do";

    public String createTeam(String team_name) throws IOException {
        return this.createTeam(team_name, null);
    }

    public String createTeam(String team_name, String members) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (team_name != null) {
            queryString.put("team_name", HttpUtility.urlEncode(team_name));
        }
        if (members != null) {
            queryString.put("members", HttpUtility.urlEncode(members));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_TEAM_URI);
    }

    public String createUser(String first_name, String last_name, String email_address, String roles) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (first_name != null) {
            queryString.put("first_name", HttpUtility.urlEncode(first_name));
        }
        if (last_name != null) {
            queryString.put("last_name", HttpUtility.urlEncode(last_name));
        }
        if (email_address != null) {
            queryString.put("email_address", HttpUtility.urlEncode(email_address));
        }
        if (roles != null) {
            queryString.put("roles", HttpUtility.urlEncode(roles));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_USER_URI);
    }

    public String deleteTeam(String team_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (team_id != null) {
            queryString.put("team_id", HttpUtility.urlEncode(team_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_TEAM_URI);
    }

    public String deleteUser(String username, String custom_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (username != null) {
            queryString.put("username", HttpUtility.urlEncode(username));
        }
        if (custom_id != null) {
            queryString.put("custom_id", HttpUtility.urlEncode(custom_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_USER_URI);
    }

    public String getCurriculumList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_CURRICULUM_LIST_URI);
    }

    public String getTeamList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_TEAM_LIST_URI);
    }

    public String getTrackList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_TRACK_LIST_URI);
    }

    public String getUserInfo(String username, String custom_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (username != null) {
            queryString.put("username", HttpUtility.urlEncode(username));
        }
        if (custom_id != null) {
            queryString.put("custom_id", HttpUtility.urlEncode(custom_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_USER_INFO_URI);
    }

    public String getUserList() throws IOException {
        return this.getUserList(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String getUserList(String first_name, String last_name, String custom_id, String email_address, String login_account_type, String phone, String teams, String roles, String is_saml_user, String login_enabled, String requires_token, String is_elearning_manager, String elearning_manager, String elearning_track, String elearning_curriculum, String keep_elearning_active, String custom_one, String custom_two, String custom_three, String custom_four, String custom_five) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (first_name != null) {
            queryString.put("first_name", HttpUtility.urlEncode(first_name));
        }
        if (last_name != null) {
            queryString.put("last_name", HttpUtility.urlEncode(last_name));
        }
        if (custom_id != null) {
            queryString.put("custom_id", HttpUtility.urlEncode(custom_id));
        }
        if (email_address != null) {
            queryString.put("email_address", HttpUtility.urlEncode(email_address));
        }
        if (login_account_type != null) {
            queryString.put("login_account_type", HttpUtility.urlEncode(login_account_type));
        }
        if (phone != null) {
            queryString.put("phone", HttpUtility.urlEncode(phone));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (roles != null) {
            queryString.put("roles", HttpUtility.urlEncode(roles));
        }
        if (is_saml_user != null) {
            queryString.put("is_saml_user", HttpUtility.urlEncode(is_saml_user));
        }
        if (login_enabled != null) {
            queryString.put("login_enabled", HttpUtility.urlEncode(login_enabled));
        }
        if (requires_token != null) {
            queryString.put("requires_token", HttpUtility.urlEncode(requires_token));
        }
        if (is_elearning_manager != null) {
            queryString.put("is_elearning_manager", HttpUtility.urlEncode(is_elearning_manager));
        }
        if (elearning_manager != null) {
            queryString.put("elearning_manager", HttpUtility.urlEncode(elearning_manager));
        }
        if (elearning_track != null) {
            queryString.put("elearning_track", HttpUtility.urlEncode(elearning_track));
        }
        if (elearning_curriculum != null) {
            queryString.put("elearning_curriculum", HttpUtility.urlEncode(elearning_curriculum));
        }
        if (keep_elearning_active != null) {
            queryString.put("keep_elearning_active", HttpUtility.urlEncode(keep_elearning_active));
        }
        if (custom_one != null) {
            queryString.put("custom_one", HttpUtility.urlEncode(custom_one));
        }
        if (custom_two != null) {
            queryString.put("custom_two", HttpUtility.urlEncode(custom_two));
        }
        if (custom_three != null) {
            queryString.put("custom_three", HttpUtility.urlEncode(custom_three));
        }
        if (custom_four != null) {
            queryString.put("custom_four", HttpUtility.urlEncode(custom_four));
        }
        if (custom_five != null) {
            queryString.put("custom_five", HttpUtility.urlEncode(custom_five));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_USER_LIST_URI);
    }

    public String updateTeam(String team_id) throws IOException {
        return this.updateTeam(null, team_id, null);
    }

    public String updateTeam(String members, String team_id, String team_name) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (members != null) {
            queryString.put("members", HttpUtility.urlEncode(members));
        }
        if (team_id != null) {
            queryString.put("team_id", HttpUtility.urlEncode(team_id));
        }
        if (team_name != null) {
            queryString.put("team_name", HttpUtility.urlEncode(team_name));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_TEAM_URI);
    }

    public String updateUser(String username, String custom_id) throws IOException {
        return this.updateUser(username, custom_id, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String updateUser(String username, String custom_id, String first_name, String last_name, String email_address, String new_custom_id, String login_account_type, String phone, String teams, String roles, String is_saml_user, String login_enabled, String requires_token, String is_elearning_manager, String elearning_manager, String elearning_track, String elearning_curriculum, String keep_elearning_active, String custom_one, String custom_two, String custom_three, String custom_four, String custom_five) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (username != null) {
            queryString.put("username", HttpUtility.urlEncode(username));
        }
        if (custom_id != null) {
            queryString.put("custom_id", HttpUtility.urlEncode(custom_id));
        }
        if (first_name != null) {
            queryString.put("first_name", HttpUtility.urlEncode(first_name));
        }
        if (last_name != null) {
            queryString.put("last_name", HttpUtility.urlEncode(last_name));
        }
        if (email_address != null) {
            queryString.put("email_address", HttpUtility.urlEncode(email_address));
        }
        if (new_custom_id != null) {
            queryString.put("new_custom_id", HttpUtility.urlEncode(new_custom_id));
        }
        if (login_account_type != null) {
            queryString.put("login_account_type", HttpUtility.urlEncode(login_account_type));
        }
        if (phone != null) {
            queryString.put("phone", HttpUtility.urlEncode(phone));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (roles != null) {
            queryString.put("roles", HttpUtility.urlEncode(roles));
        }
        if (is_saml_user != null) {
            queryString.put("is_saml_user", HttpUtility.urlEncode(is_saml_user));
        }
        if (login_enabled != null) {
            queryString.put("login_enabled", HttpUtility.urlEncode(login_enabled));
        }
        if (requires_token != null) {
            queryString.put("requires_token", HttpUtility.urlEncode(requires_token));
        }
        if (is_elearning_manager != null) {
            queryString.put("is_elearning_manager", HttpUtility.urlEncode(is_elearning_manager));
        }
        if (elearning_manager != null) {
            queryString.put("elearning_manager", HttpUtility.urlEncode(elearning_manager));
        }
        if (elearning_track != null) {
            queryString.put("elearning_track", HttpUtility.urlEncode(elearning_track));
        }
        if (elearning_curriculum != null) {
            queryString.put("elearning_curriculum", HttpUtility.urlEncode(elearning_curriculum));
        }
        if (keep_elearning_active != null) {
            queryString.put("keep_elearning_active", HttpUtility.urlEncode(keep_elearning_active));
        }
        if (custom_one != null) {
            queryString.put("custom_one", HttpUtility.urlEncode(custom_one));
        }
        if (custom_two != null) {
            queryString.put("custom_two", HttpUtility.urlEncode(custom_two));
        }
        if (custom_three != null) {
            queryString.put("custom_three", HttpUtility.urlEncode(custom_three));
        }
        if (custom_four != null) {
            queryString.put("custom_four", HttpUtility.urlEncode(custom_four));
        }
        if (custom_five != null) {
            queryString.put("custom_five", HttpUtility.urlEncode(custom_five));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_USER_URI);
    }
}

