/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Emoji;
import com.vdurmont.emoji.EmojiManager;
import com.vdurmont.emoji.EmojiTrie;
import com.vdurmont.emoji.Fitzpatrick;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiParser {
    private static final Pattern ALIAS_CANDIDATE_PATTERN = Pattern.compile("(?<=:)\\+?(\\w|\\||\\-)+(?=:)");
    private static final Pattern ALL_FITZPATRICK_CODES;

    private EmojiParser() {
    }

    public static String parseToAliases(String input) {
        return EmojiParser.parseToAliases(input, FitzpatrickAction.PARSE);
    }

    public static String parseToAliases(String input, FitzpatrickAction fitzpatrickAction) {
        if (fitzpatrickAction == FitzpatrickAction.REMOVE) {
            input = EmojiParser.removeFitzpatrick(input);
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(input);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(input.substring(prev, candidate.startIndex));
            if (fitzpatrickAction == FitzpatrickAction.PARSE && candidate.emoji.supportsFitzpatrick() && candidate.fitzpatrick != null) {
                sb.append(":").append(candidate.emoji.getAliases().get(0)).append("|");
                sb.append(candidate.fitzpatrick.name().toLowerCase()).append(":");
                prev = candidate.getEndIndexWithFitzpatrick();
                continue;
            }
            sb.append(":").append(candidate.emoji.getAliases().get(0)).append(":");
            prev = candidate.endIndex;
        }
        return sb.append(input.substring(prev)).toString();
    }

    public static String parseToUnicode(String input) {
        List<AliasCandidate> candidates = EmojiParser.getAliasCandidates(input);
        String result = input;
        for (AliasCandidate candidate : candidates) {
            Emoji emoji = EmojiManager.getForAlias(candidate.alias);
            if (emoji == null || !emoji.supportsFitzpatrick() && (emoji.supportsFitzpatrick() || candidate.fitzpatrick != null)) continue;
            String replacement = emoji.getUnicode();
            if (candidate.fitzpatrick != null) {
                replacement = replacement + candidate.fitzpatrick.unicode;
            }
            result = result.replace(":" + candidate.fullString + ":", replacement);
        }
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getHtmlHexidecimal(), emoji.getUnicode());
            result = result.replace(emoji.getHtmlDecimal(), emoji.getUnicode());
        }
        return result;
    }

    protected static List<AliasCandidate> getAliasCandidates(String input) {
        ArrayList<AliasCandidate> candidates = new ArrayList<AliasCandidate>();
        Matcher matcher = ALIAS_CANDIDATE_PATTERN.matcher(input);
        matcher = matcher.useTransparentBounds(true);
        while (matcher.find()) {
            String match = matcher.group();
            if (!match.contains("|")) {
                candidates.add(new AliasCandidate(match, match, null));
                continue;
            }
            String[] splitted = match.split("\\|");
            if (splitted.length == 2 || splitted.length > 2) {
                candidates.add(new AliasCandidate(match, splitted[0], splitted[1]));
                continue;
            }
            candidates.add(new AliasCandidate(match, match, null));
        }
        return candidates;
    }

    public static String parseToHtmlDecimal(String input) {
        return EmojiParser.parseToHtmlDecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlDecimal(String input, FitzpatrickAction fitzpatrickAction) {
        if (fitzpatrickAction != FitzpatrickAction.IGNORE) {
            input = EmojiParser.removeFitzpatrick(input);
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(input);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(input.substring(prev, candidate.startIndex)).append(candidate.emoji.getHtmlDecimal());
            prev = candidate.endIndex;
        }
        return sb.append(input.substring(prev)).toString();
    }

    public static String parseToHtmlHexadecimal(String input) {
        return EmojiParser.parseToHtmlHexadecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlHexadecimal(String input, FitzpatrickAction fitzpatrickAction) {
        if (fitzpatrickAction != FitzpatrickAction.IGNORE) {
            input = EmojiParser.removeFitzpatrick(input);
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(input);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(input.substring(prev, candidate.startIndex)).append(candidate.emoji.getHtmlHexidecimal());
            prev = candidate.endIndex;
        }
        return sb.append(input.substring(prev)).toString();
    }

    private static String removeFitzpatrick(String input) {
        return ALL_FITZPATRICK_CODES.matcher(input).replaceAll("");
    }

    public static String removeAllEmojis(String str) {
        str = EmojiParser.removeFitzpatrick(str);
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(str);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(str.substring(prev, candidate.startIndex));
            prev = candidate.endIndex;
        }
        return sb.append(str.substring(prev)).toString();
    }

    public static String removeEmojis(String str, Collection<Emoji> emojisToRemove) {
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(str);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(str.substring(prev, candidate.startIndex));
            prev = candidate.getEndIndexWithFitzpatrick();
            if (emojisToRemove.contains(candidate.emoji)) continue;
            sb.append(candidate.getEmojiUnicodeWithFitzpatrick());
        }
        return sb.append(str.substring(prev)).toString();
    }

    public static String removeAllEmojisExcept(String str, Collection<Emoji> emojisToKeep) {
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(str);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(str.substring(prev, candidate.startIndex));
            prev = candidate.getEndIndexWithFitzpatrick();
            if (!emojisToKeep.contains(candidate.emoji)) continue;
            sb.append(candidate.getEmojiUnicodeWithFitzpatrick());
        }
        return sb.append(str.substring(prev)).toString();
    }

    private static List<UnicodeCandidate> getUnicodeCandidates(String input) {
        char[] inputCharArray = input.toCharArray();
        ArrayList<UnicodeCandidate> candidates = new ArrayList<UnicodeCandidate>();
        for (int i = 0; i < input.length(); ++i) {
            int emojiEnd = EmojiParser.getEmojiEndPos(inputCharArray, i);
            if (emojiEnd == -1) continue;
            String emojiString = input.substring(i, emojiEnd);
            String fitzpatrickString = emojiEnd + 2 <= input.length() ? input.substring(emojiEnd, emojiEnd + 2) : null;
            candidates.add(new UnicodeCandidate(emojiString, fitzpatrickString, i, emojiEnd));
            i = emojiEnd;
        }
        return candidates;
    }

    private static int getEmojiEndPos(char[] text, int startPos) {
        int best = -1;
        for (int j = startPos + 1; j <= text.length; ++j) {
            EmojiTrie.Matches status = EmojiManager.isEmoji(Arrays.copyOfRange(text, startPos, j));
            if (status.exactMatch()) {
                best = j;
                continue;
            }
            if (!status.impossibleMatch()) continue;
            return best;
        }
        return best;
    }

    static {
        String fitzpatrickRegexString = "";
        for (Fitzpatrick fitzpatrick : Fitzpatrick.values()) {
            fitzpatrickRegexString = fitzpatrickRegexString + "|" + fitzpatrick.unicode;
        }
        ALL_FITZPATRICK_CODES = Pattern.compile("(?:" + fitzpatrickRegexString.substring(1) + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FitzpatrickAction {
        PARSE,
        REMOVE,
        IGNORE;

    }

    protected static class AliasCandidate {
        public final String fullString;
        public final String alias;
        public final Fitzpatrick fitzpatrick;

        private AliasCandidate(String fullString, String alias, String fitzpatrickString) {
            this.fullString = fullString;
            this.alias = alias;
            this.fitzpatrick = fitzpatrickString == null ? null : Fitzpatrick.fitzpatrickFromType(fitzpatrickString);
        }
    }

    protected static class UnicodeCandidate {
        public final Emoji emoji;
        public final Fitzpatrick fitzpatrick;
        public final int startIndex;
        public final int endIndex;

        private UnicodeCandidate(String emoji, String fitzpatrick, int startIndex, int endIndex) {
            this.emoji = EmojiManager.getByUnicode(emoji);
            this.fitzpatrick = Fitzpatrick.fitzpatrickFromUnicode(fitzpatrick);
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getEmojiUnicodeWithFitzpatrick() {
            if (this.emoji.supportsFitzpatrick()) {
                return this.emoji.getUnicode(this.fitzpatrick);
            }
            return this.emoji.getUnicode();
        }

        public int getEndIndexWithFitzpatrick() {
            if (this.fitzpatrick != null) {
                return this.endIndex + 2;
            }
            return this.endIndex;
        }
    }
}

