/*
 * Decompiled with CFR 0.152.
 */
package com.varunjohn1990.iosdialogs4android;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.varunjohn1990.iosdialogs4android.IOSDialog;
import com.varunjohn1990.iosdialogs4android.IOSDialogButton;
import com.varunjohn1990.iosdialogs4android.R;

public class IOSDialogView
extends AppCompatActivity
implements View.OnClickListener {
    private Context context;
    private static IOSDialog iosDialog;
    private View layoutDialog;
    private View layoutContent;
    private View layoutNegative;
    private TextView textViewTitle;
    private TextView textViewMessage;
    private TextView textViewNegative;
    private TextView textViewPositive;
    private LinearLayout layout2Options;
    private LinearLayout layoutMultipleOptions;
    float dp;
    private boolean isAnimationExitDone;

    protected static void open(Context context, IOSDialog iosDialog) {
        IOSDialogView.iosDialog = iosDialog;
        context.startActivity(new Intent(context, IOSDialogView.class).addFlags(0x4000000).addFlags(0x10000000));
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.overridePendingTransition(0, 0);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_iosdialog);
        this.context = this;
        this.dp = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        this.layoutDialog = this.findViewById(R.id.layoutDialog);
        this.layoutContent = this.findViewById(R.id.layoutContent);
        this.layoutNegative = this.findViewById(R.id.layoutNegative);
        this.textViewTitle = (TextView)this.findViewById(R.id.textViewTitle);
        this.textViewMessage = (TextView)this.findViewById(R.id.textViewMessage);
        this.textViewNegative = (TextView)this.findViewById(R.id.textViewNegative);
        this.textViewPositive = (TextView)this.findViewById(R.id.textViewPositive);
        this.layout2Options = (LinearLayout)this.findViewById(R.id.layout2Options);
        this.layoutMultipleOptions = (LinearLayout)this.findViewById(R.id.layoutMultipleOptions);
        IOSDialog.iosDialogView = this;
        if (iosDialog.isEnableAnimation()) {
            this.layoutDialog.setScaleX(1.4f);
            this.layoutDialog.setScaleY(1.4f);
            this.layoutContent.setAlpha(0.0f);
            this.layoutContent.animate().alpha(1.0f).setDuration(400L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
            this.layoutDialog.animate().scaleX(1.0f).scaleY(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
        }
        if (iosDialog.getTitle() != null) {
            this.textViewTitle.setText((CharSequence)iosDialog.getTitle());
        } else {
            this.textViewTitle.setVisibility(8);
        }
        if (iosDialog.getMessage() != null) {
            this.textViewMessage.setText((CharSequence)iosDialog.getMessage());
        } else {
            this.textViewMessage.setText((CharSequence)"");
        }
        if (!iosDialog.isMultiOptions()) {
            this.layout2Options.setVisibility(0);
            this.layoutMultipleOptions.setVisibility(8);
            if (iosDialog.getPositiveButtonText() != null) {
                this.textViewPositive.setText((CharSequence)iosDialog.getPositiveButtonText());
            } else {
                this.textViewPositive.setText((CharSequence)"Ok");
            }
            if (iosDialog.getNegativeButtonText() != null) {
                this.textViewNegative.setText((CharSequence)iosDialog.getNegativeButtonText());
            } else {
                this.textViewNegative.setText((CharSequence)"");
                this.layoutNegative.setVisibility(8);
            }
            this.textViewPositive.setOnClickListener((View.OnClickListener)this);
            this.textViewNegative.setOnClickListener((View.OnClickListener)this);
        } else {
            this.layout2Options.setVisibility(8);
            this.layoutMultipleOptions.setVisibility(0);
            if (iosDialog.getIosDialogButtons() != null && !iosDialog.getIosDialogButtons().isEmpty()) {
                this.layoutMultipleOptions.removeAllViews();
                for (final IOSDialogButton iosDialogButton : iosDialog.getIosDialogButtons()) {
                    LinearLayout separator = new LinearLayout(this.context);
                    separator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, Math.round(1.0f * this.dp)));
                    separator.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.separator_ios_dialog));
                    this.layoutMultipleOptions.addView((View)separator);
                    TextView button = new TextView(this.context);
                    button.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, (int)(48.0f * this.dp)));
                    button.setBackgroundResource(R.drawable.click_highlight);
                    button.setClickable(true);
                    button.setText((CharSequence)iosDialogButton.getText());
                    button.setMaxLines(1);
                    button.setGravity(17);
                    button.setTextSize(2, 15.0f);
                    button.setShadowLayer(1.0f, 1.0f, 1.0f, ContextCompat.getColor((Context)this.context, (int)R.color.text_shadow));
                    if (iosDialogButton.getType() == 2) {
                        button.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.action_button_negative_ios_dialog));
                    } else {
                        button.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.action_button_ios_dialog));
                    }
                    if (iosDialogButton.isMakeBold()) {
                        button.setTypeface(Typeface.DEFAULT_BOLD);
                    }
                    button.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (iosDialog.getIosDialogMultiOptionsListeners() != null) {
                                iosDialog.getIosDialogMultiOptionsListeners().onClick(iosDialog, iosDialogButton);
                            } else {
                                IOSDialogView.this.dismiss();
                            }
                        }
                    });
                    this.layoutMultipleOptions.addView((View)button);
                }
            }
        }
    }

    public void onOutsideClick(View view) {
        if (iosDialog.isCancelable()) {
            if (iosDialog.getCancelListener() != null) {
                iosDialog.getCancelListener().onClick(iosDialog);
            }
            this.onBackPressed();
        }
    }

    public void onBackPressed() {
        if (this.isAnimationExitDone || !iosDialog.isEnableAnimation()) {
            this.overridePendingTransition(0, 0);
            this.finish();
            this.overridePendingTransition(0, 0);
        }
        this.layoutContent.animate().alpha(0.0f).setDuration(200L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                IOSDialogView.this.isAnimationExitDone = true;
                IOSDialogView.this.onBackPressed();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).start();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.textViewPositive) {
            if (iosDialog.getPositiveClickListener() != null) {
                iosDialog.getPositiveClickListener().onClick(iosDialog);
            } else {
                this.dismiss();
            }
        } else if (id2 == R.id.textViewNegative) {
            if (iosDialog.getNegativeClickListener() != null) {
                iosDialog.getNegativeClickListener().onClick(iosDialog);
            } else {
                this.dismiss();
            }
        }
    }

    public void dismiss() {
        this.onBackPressed();
    }
}

