/*
 * Decompiled with CFR 0.152.
 */
package com.varunjohn1990.iosdialogs4android;

import android.content.Context;
import android.view.View;
import com.varunjohn1990.iosdialogs4android.IOSDialogActivity;

public class IOSDialog {
    private String title;
    private String message;
    private String positiveButtonText;
    private String negativeButtonText;
    private Listener positiveClickListener;
    private Listener negativeClickListener;
    private Listener cancelListener;
    private boolean enableAnimation = true;
    private boolean cancelable = true;
    private View view;
    static IOSDialogActivity iosDialogActivity;
    private Context context;

    private IOSDialog(Context context) {
        this.context = context;
    }

    public void show() {
        IOSDialogActivity.openActivity(this.context, this);
    }

    public void dismiss() {
        if (iosDialogActivity != null) {
            iosDialogActivity.dismiss();
        }
    }

    public View getView() {
        return this.view;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPositiveButtonText() {
        return this.positiveButtonText;
    }

    public String getNegativeButtonText() {
        return this.negativeButtonText;
    }

    public Listener getPositiveClickListener() {
        return this.positiveClickListener;
    }

    public Listener getNegativeClickListener() {
        return this.negativeClickListener;
    }

    public Listener getCancelListener() {
        return this.cancelListener;
    }

    public boolean isEnableAnimation() {
        return this.enableAnimation;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public static class Builder {
        private IOSDialog iosDialog;
        private Context context;

        public Builder(Context context) {
            this.context = context;
            this.iosDialog = new IOSDialog(context);
        }

        public IOSDialog build() {
            return this.iosDialog;
        }

        public Builder title(String title) {
            this.iosDialog.title = title;
            return this;
        }

        public Builder message(String message) {
            this.iosDialog.message = message;
            return this;
        }

        public Builder title(int titleResourceId) {
            this.iosDialog.title = this.context.getString(titleResourceId);
            return this;
        }

        public Builder message(int messageResourceId) {
            this.iosDialog.message = this.context.getString(messageResourceId);
            return this;
        }

        public Builder positiveButtonText(String positiveButtonText) {
            this.iosDialog.positiveButtonText = positiveButtonText;
            return this;
        }

        public Builder negativeButtonText(String negativeButtonText) {
            this.iosDialog.negativeButtonText = negativeButtonText;
            return this;
        }

        public Builder positiveButtonText(int positiveButtonTextResourceId) {
            this.iosDialog.positiveButtonText = this.context.getString(positiveButtonTextResourceId);
            return this;
        }

        public Builder negativeButtonText(int negativeButtonTextResourceId) {
            this.iosDialog.negativeButtonText = this.context.getString(negativeButtonTextResourceId);
            return this;
        }

        public Builder positiveClickListener(Listener positiveClickListener) {
            this.iosDialog.positiveClickListener = positiveClickListener;
            return this;
        }

        public Builder negativeClickListener(Listener negativeClickListener) {
            this.iosDialog.negativeClickListener = negativeClickListener;
            return this;
        }

        public Builder cancelListener(Listener cancelListener) {
            this.iosDialog.cancelListener = cancelListener;
            return this;
        }

        public Builder enableAnimation(boolean enableAnimation) {
            this.iosDialog.enableAnimation = enableAnimation;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.iosDialog.cancelable = cancelable;
            return this;
        }
    }

    public static interface Listener {
        public void onClick(IOSDialog var1);
    }
}

