/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink;

import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.lang.reflect.Method;

public final class WifiApManager {
    private static final int WIFI_AP_STATE_FAILED = 4;
    private final WifiManager mWifiManager;
    private final String TAG = "Wifi Access Manager";
    private Method wifiControlMethod;
    private Method wifiApConfigurationMethod;
    private Method wifiApState;

    public WifiApManager(Context context) throws SecurityException, NoSuchMethodException {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.wifiControlMethod = this.mWifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
        this.wifiApConfigurationMethod = this.mWifiManager.getClass().getMethod("getWifiApConfiguration", null);
        this.wifiApState = this.mWifiManager.getClass().getMethod("getWifiApState", new Class[0]);
    }

    public boolean setWifiApState(WifiConfiguration config, boolean enabled) {
        try {
            if (enabled) {
                this.mWifiManager.setWifiEnabled(!enabled);
            }
            return (Boolean)this.wifiControlMethod.invoke((Object)this.mWifiManager, config, enabled);
        }
        catch (Exception e) {
            Log.e((String)"Wifi Access Manager", (String)"", (Throwable)e);
            return false;
        }
    }

    public WifiConfiguration getWifiApConfiguration() {
        try {
            return (WifiConfiguration)this.wifiApConfigurationMethod.invoke((Object)this.mWifiManager, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getWifiApState() {
        try {
            return (Integer)this.wifiApState.invoke((Object)this.mWifiManager, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)"Wifi Access Manager", (String)"", (Throwable)e);
            return 4;
        }
    }
}

