/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink;

import com.mxchip.easylink.EasyServlet;
import com.mxchip.easylink.FTCListener;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class EasyServer {
    private static final String TAG = "JServer";
    private static final String ASSETS_DIR = "jetty";
    private int mPort;
    public Server mServer;

    public EasyServer(int port) {
        this.mPort = port;
    }

    public synchronized void start(FTCListener ftcl) {
        if (this.mServer != null && this.mServer.isStarted()) {
            return;
        }
        if (this.mServer == null) {
            ServletContextHandler servletHandler = new ServletContextHandler(1);
            servletHandler.addServlet(new ServletHolder(new EasyServlet(ftcl)), "/auth-setup");
            HandlerList handlerList = new HandlerList();
            handlerList.addHandler(servletHandler);
            this.mServer = new Server(this.mPort);
            this.mServer.setHandler(handlerList);
        }
        try {
            this.mServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.mServer == null || this.mServer.isStopped()) {
            return;
        }
        try {
            this.mServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isStarted() {
        if (this.mServer == null) {
            return false;
        }
        return this.mServer.isStarted();
    }
}

