/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.helper;

public class RC4 {
    private final byte[] S = new byte[256];
    private final byte[] T = new byte[256];
    private final int keylen;

    public RC4(byte[] key) {
        if (key.length < 1 || key.length > 256) {
            throw new IllegalArgumentException("key must be between 1 and 256 bytes");
        }
        this.keylen = key.length;
        int i = 0;
        while (i < 256) {
            this.S[i] = (byte)i;
            this.T[i] = key[i % this.keylen];
            ++i;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < 256) {
            j = j + this.S[i2] + this.T[i2] & 0xFF;
            byte tmp = this.S[j];
            this.S[j] = this.S[i2];
            this.S[i2] = tmp;
            ++i2;
        }
    }

    public byte[] encrypt(byte[] plaintext) {
        byte[] ciphertext = new byte[plaintext.length];
        int i = 0;
        int j = 0;
        int counter = 0;
        while (counter < plaintext.length) {
            i = i + 1 & 0xFF;
            j = j + this.S[i] & 0xFF;
            byte tmp = this.S[j];
            this.S[j] = this.S[i];
            this.S[i] = tmp;
            int t = this.S[i] + this.S[j] & 0xFF;
            byte k = this.S[t];
            ciphertext[counter] = (byte)(plaintext[counter] ^ k);
            ++counter;
        }
        return ciphertext;
    }

    public byte[] decrypt(byte[] ciphertext) {
        return this.encrypt(ciphertext);
    }
}

