/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class ProKey {
    private static final String FIELD_NAME = "username";
    private static final String FIELD_KEY = "proKey";
    private final String username;
    private final String key;

    ProKey(String username, String key) {
        this.username = username;
        this.key = key;
    }

    public String getUsername() {
        return this.username;
    }

    public String getKey() {
        return this.key;
    }

    String toJson() {
        ObjectNode json = JsonHelpers.getJsonMapper().createObjectNode();
        json.put(FIELD_NAME, this.username);
        json.put(FIELD_KEY, this.key);
        try {
            return JsonHelpers.getJsonMapper().writeValueAsString((Object)json);
        }
        catch (JacksonException e) {
            ProKey.getLogger().debug("Unable to read proKey", (Throwable)e);
            return null;
        }
    }

    static ProKey get() {
        ProKey proKey = ProKey.getSystemProperty();
        if (proKey != null) {
            return proKey;
        }
        proKey = ProKey.getEnvironmentVariable();
        if (proKey != null) {
            return proKey;
        }
        File proKeyLocation = ProKey.getFileLocation();
        try {
            proKey = ProKey.fromFile(proKeyLocation);
            return proKey;
        }
        catch (IOException e) {
            ProKey.getLogger().debug("Unable to read proKey", (Throwable)e);
            return null;
        }
    }

    private static ProKey getSystemProperty() {
        String value = System.getProperty("vaadin.proKey");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            ProKey.getLogger().debug("Unable to read pro key from the vaadin.proKey system property. The property must be of type -Dvaadin.proKey=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    private static ProKey getEnvironmentVariable() {
        String value = System.getenv("VAADIN_PRO_KEY");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            ProKey.getLogger().debug("Unable to read pro key from the VAADIN_PRO_KEY environment variable. The value must be of type VAADIN_PRO_KEY=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    private static File getFileLocation() {
        File vaadinHome = ProjectHelpers.resolveVaadinHomeDirectory();
        return new File(vaadinHome, FIELD_KEY);
    }

    static ProKey fromFile(File jsonFile) throws IOException {
        if (!jsonFile.exists()) {
            return null;
        }
        ProKey proKey = new ProKey(null, null);
        try {
            JsonNode json = JsonHelpers.getJsonMapper().readTree(jsonFile);
            proKey = new ProKey(json.get(FIELD_NAME).asString(), json.get(FIELD_KEY).asString());
            return proKey;
        }
        catch (NullPointerException | JacksonException e) {
            ProKey.getLogger().debug("Failed to parse proKey from json file", e);
            return proKey;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DevModeUsageStatistics.class.getName());
    }
}

