/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenUtils {
    private MavenUtils() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MavenUtils.class);
    }

    public static Document parsePomFileFromFolder(File projectFolder) {
        return MavenUtils.parsePomFile(new File(projectFolder, "pom.xml"));
    }

    public static Document parsePomFile(File pomFile) {
        if (!pomFile.exists()) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(pomFile);
        }
        catch (Exception e) {
            MavenUtils.getLogger().error("Unable to parse pom.xml in " + pomFile, (Throwable)e);
            return null;
        }
    }

    static String getFirstElementTextByName(Node parent, String nodeName) {
        return MavenUtils.findChild(parent, nodeName).map(Node::getTextContent).orElse(null);
    }

    public static String getGroupId(Document pom) {
        String groupId = MavenUtils.getFirstElementTextByName(pom.getDocumentElement(), "groupId");
        if (groupId == null) {
            groupId = MavenUtils.findParentTag(pom).map(parentNode -> MavenUtils.getFirstElementTextByName(parentNode, "groupId")).orElse(null);
        }
        return groupId;
    }

    private static Optional<Node> findParentTag(Document pom) {
        return MavenUtils.findChild(pom.getDocumentElement(), "parent");
    }

    public static String getArtifactId(Document pom) {
        return MavenUtils.getFirstElementTextByName(pom.getDocumentElement(), "artifactId");
    }

    private static Optional<String> getParentArtifactId(Document pom) {
        return MavenUtils.findParentTag(pom).flatMap(parentNode -> MavenUtils.findChild(parentNode, "artifactId")).map(Node::getTextContent);
    }

    private static Optional<String> getParentRelativePath(Document pom) {
        return MavenUtils.findParentTag(pom).flatMap(parentNode -> MavenUtils.findChild(parentNode, "relativePath")).map(Node::getTextContent);
    }

    private static Optional<Node> findChild(Node node, String tagname) {
        return MavenUtils.findChildren(node, tagname).findFirst();
    }

    private static Stream<Node> findChildren(Node node, String tagname) {
        Stream.Builder<Node> builder = Stream.builder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!childNode.getNodeName().equals(tagname)) continue;
            builder.add(childNode);
        }
        return builder.build();
    }

    public static File getParentPomOfMultiModuleProject(File pomFile) {
        Document pom = MavenUtils.parsePomFile(pomFile);
        if (pom == null) {
            return null;
        }
        Optional<String> parent = MavenUtils.getParentArtifactId(pom);
        if (!parent.isPresent()) {
            return null;
        }
        File pomFolder = pomFile.getParentFile();
        File parentPomFile = MavenUtils.getParentRelativePath(pom).map(relativePath -> new File(pomFolder, (String)relativePath)).map(relativePath -> {
            if (!relativePath.isFile()) {
                relativePath = new File((File)relativePath, "pom.xml");
            }
            return relativePath;
        }).orElse(new File(pomFolder.getParentFile(), "pom.xml"));
        Document parentFolderPom = MavenUtils.parsePomFile(parentPomFile);
        if (parentFolderPom == null) {
            return null;
        }
        String parentFolderArtifactId = MavenUtils.getArtifactId(parentFolderPom);
        if (Objects.equals(parent.get(), parentFolderArtifactId)) {
            try {
                return parentPomFile.getCanonicalFile();
            }
            catch (IOException e) {
                return parentPomFile;
            }
        }
        return null;
    }

    public static List<String> getModuleFolders(Document pom) {
        return MavenUtils.findChild(pom.getDocumentElement(), "modules").stream().flatMap(node -> MavenUtils.findChildren(node, "module")).map(Node::getTextContent).map(possiblyFilename -> MavenUtils.removeAfter(possiblyFilename, "/")).toList();
    }

    private static String removeAfter(String str, String delimiter) {
        int i = str.lastIndexOf(delimiter);
        if (i != -1) {
            return str.substring(0, i);
        }
        return str;
    }
}

