/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.AbstractDevServerRunner;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.FrontendTools;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViteHandler
extends AbstractDevServerRunner {
    public static final String VITE_SERVER = "node_modules/vite/bin/vite.js";

    public ViteHandler(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        super(lookup, runningPort, npmFolder, waitFor);
    }

    @Override
    protected List<String> getServerStartupCommand(FrontendTools frontendTools) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(frontendTools.getNodeExecutable());
        command.add(this.getServerBinary().getAbsolutePath());
        command.add("--config");
        command.add(this.getServerConfig().getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.getPort()));
        command.add("--base");
        command.add(this.getContextPath() + "/VAADIN/");
        String customParameters = this.getApplicationConfiguration().getStringProperty("devmode.vite.options", "");
        if (!customParameters.isEmpty()) {
            command.addAll(Arrays.asList(customParameters.split(" +")));
            ViteHandler.getLogger().info("Starting {} using: {}", (Object)this.getServerName(), (Object)String.join((CharSequence)" ", command));
        }
        return command;
    }

    @Override
    protected String getServerName() {
        return "Vite";
    }

    @Override
    protected File getServerBinary() {
        return new File(this.getProjectRoot(), VITE_SERVER);
    }

    @Override
    protected File getServerConfig() {
        return new File(this.getProjectRoot(), "vite.config.ts");
    }

    @Override
    protected Pattern getServerFailurePattern() {
        return null;
    }

    @Override
    protected Pattern getServerSuccessPattern() {
        return Pattern.compile("ready in .*ms");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ViteHandler.class);
    }

    @Override
    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        if (path.equals("/index.html")) {
            return super.prepareConnection(this.getContextPath() + "/VAADIN/index.html", method);
        }
        if (path.equals("/web-component.html")) {
            return super.prepareConnection(this.getContextPath() + "/VAADIN/web-component.html", method);
        }
        if (path.equals("/sw.js")) {
            return super.prepareConnection(this.getContextPath() + "/VAADIN/sw.js", method);
        }
        return super.prepareConnection(this.getContextPath() + path, method);
    }

    private String getContextPath() {
        VaadinServletContext servletContext = (VaadinServletContext)this.getApplicationConfiguration().getContext();
        return servletContext.getContext().getContextPath();
    }
}

