/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone.nodes;

import com.vaadin.hilla.parser.core.AbstractNode;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;

public final class TypeSignatureNode
extends AbstractNode<SignatureModel, Schema<?>>
implements TypedNode {
    private final List<AnnotationInfoModel> annotations;
    private final Integer position;

    private TypeSignatureNode(SignatureModel source, Schema<?> target, List<AnnotationInfoModel> annotations, Integer position) {
        super((Object)source, target);
        this.annotations = annotations;
        this.position = position;
    }

    private TypeSignatureNode(SignatureModel source, Schema<?> target, Integer position) {
        this(source, target, source.getAnnotations(), position);
    }

    @Override
    public List<AnnotationInfoModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    public SignatureModel getType() {
        return (SignatureModel)this.getSource();
    }

    @Override
    public TypedNode processType(UnaryOperator<SignatureModel> typeProcessor) {
        SignatureModel processedType = (SignatureModel)typeProcessor.apply((SignatureModel)this.getSource());
        if (processedType.equals(this.getSource())) {
            return this;
        }
        return new TypeSignatureNode((SignatureModel)typeProcessor.apply((SignatureModel)this.getSource()), (Schema)this.getTarget(), this.annotations, this.position);
    }

    public static @NonNull TypeSignatureNode of(@NonNull SignatureModel source) {
        return new TypeSignatureNode(source, new Schema(), null);
    }

    public static @NonNull TypeSignatureNode of(@NonNull SignatureModel source, int position) {
        return new TypeSignatureNode(source, new Schema(), position);
    }

    public boolean equals(Object o) {
        boolean eq = super.equals(o);
        if (eq) {
            TypeSignatureNode other = (TypeSignatureNode)o;
            eq = Objects.equals(this.position, other.position);
        }
        return eq;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.position);
    }

    public String toString() {
        Object str = super.toString();
        if (this.position != null) {
            str = (String)str + "[" + this.position + "]";
        }
        return str;
    }
}

