/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webpush;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.webpush.WebPushException;
import com.vaadin.flow.server.webpush.WebPushKeys;
import com.vaadin.flow.server.webpush.WebPushMessage;
import com.vaadin.flow.server.webpush.WebPushState;
import com.vaadin.flow.server.webpush.WebPushSubscription;
import com.vaadin.flow.server.webpush.WebPushSubscriptionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import nl.martijndwars.webpush.JdkHttpClientPushService;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import nl.martijndwars.webpush.Subscription;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class WebPush {
    private PushService pushService;
    private String publicKey;
    private final SerializableConsumer<String> errorHandler = (SerializableConsumer & Serializable)err -> {
        throw new RuntimeException("Unable to execute web push command. JS error is '" + err + "'");
    };

    public WebPush(String publicKey, String privateKey, String subject) {
        this.publicKey = publicKey;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            this.pushService = ((JdkHttpClientPushService.Builder)((JdkHttpClientPushService.Builder)((JdkHttpClientPushService.Builder)PushService.builder().withVapidPublicKey(publicKey)).withVapidPrivateKey(privateKey)).withVapidSubject(subject)).build();
        }
        catch (GeneralSecurityException e) {
            throw new WebPushException("Security exception initializing web push PushService", e);
        }
    }

    public void sendNotification(WebPushSubscription subscription, WebPushMessage message) throws WebPushException {
        int statusCode = -1;
        HttpResponse response = null;
        try {
            Subscription.Keys keys = null;
            if (subscription.keys() != null) {
                keys = new Subscription.Keys(subscription.keys().p256dh(), subscription.keys().auth());
            }
            Subscription nativeSubscription = new Subscription(subscription.endpoint(), keys);
            Notification notification = Notification.builder().subscription(nativeSubscription).payload(message.toJson()).build();
            response = this.pushService.send(notification, PushService.DEFAULT_ENCODING, HttpResponse.BodyHandlers.ofString());
            statusCode = response.statusCode();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to send notification.", (Throwable)e);
            throw new WebPushException("Sending of web push notification failed", e);
        }
        if (statusCode != 201) {
            this.getLogger().error("Failed to send web push notification, received status code:" + statusCode);
            this.getLogger().error(String.join((CharSequence)"\n", (CharSequence)response.body()));
            throw new WebPushException("Sending of web push notification failed with status code " + statusCode);
        }
    }

    public void subscriptionExists(UI ui, WebPushState receiver) {
        SerializableConsumer & Serializable resultHandler = (SerializableConsumer & Serializable)json -> receiver.state(Boolean.parseBoolean(json.toString()));
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.registrationStatus()", new Serializable[0]).then((SerializableConsumer)resultHandler, this.errorHandler);
    }

    public void isNotificationDenied(UI ui, WebPushState receiver) {
        SerializableConsumer & Serializable resultHandler = (SerializableConsumer & Serializable)json -> receiver.state(Boolean.parseBoolean(json.toString()));
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.notificationDenied()", new Serializable[0]).then((SerializableConsumer)resultHandler, this.errorHandler);
    }

    public void isNotificationGranted(UI ui, WebPushState receiver) {
        SerializableConsumer & Serializable resultHandler = (SerializableConsumer & Serializable)json -> receiver.state(Boolean.parseBoolean(json.toString()));
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.notificationGranted()", new Serializable[0]).then((SerializableConsumer)resultHandler, this.errorHandler);
    }

    public void subscribe(UI ui, WebPushSubscriptionResponse receiver) {
        SerializableConsumer & Serializable resultHandler = (SerializableConsumer & Serializable)json -> {
            ObjectNode responseJson = JacksonUtils.readTree((String)json.toString());
            receiver.subscription(this.generateSubscription(responseJson));
        };
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.subscribe($0)", new Serializable[]{this.publicKey}).then((SerializableConsumer)resultHandler, this.errorHandler);
    }

    public void unsubscribe(UI ui, WebPushSubscriptionResponse receiver) {
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.unsubscribe()", new Serializable[0]).then(this.handlePossiblyEmptySubscription(receiver), this.errorHandler);
    }

    public void fetchExistingSubscription(UI ui, WebPushSubscriptionResponse receiver) {
        this.executeJavascript(ui, "return window.Vaadin.Flow.webPush.getSubscription()", new Serializable[0]).then(this.handlePossiblyEmptySubscription(receiver), this.errorHandler);
    }

    private PendingJavaScriptResult executeJavascript(UI ui, String script, Serializable ... parameters) {
        this.initWebPushClient(ui);
        return ui.getPage().executeJs(script, parameters);
    }

    private void initWebPushClient(UI ui) {
        if (ComponentUtil.getData((Component)ui, (String)"webPushInitialized") != null) {
            return;
        }
        ComponentUtil.setData((Component)ui, (String)"webPushInitialized", (Object)true);
        Page page = ui.getPage();
        try (InputStream stream = WebPush.class.getClassLoader().getResourceAsStream("META-INF/frontend/FlowWebPush.js");){
            page.executeJs(StringUtil.removeComments((String)IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8)), new Object[0]).then((SerializableConsumer & Serializable)unused -> this.getLogger().debug("Webpush client code initialized"), (SerializableConsumer & Serializable)err -> this.getLogger().error("Webpush client code initialization failed: {}", err));
        }
        catch (IOException ioe) {
            throw new WebPushException("Could not load webpush client code");
        }
    }

    private SerializableConsumer<JsonNode> handlePossiblyEmptySubscription(WebPushSubscriptionResponse receiver) {
        return (SerializableConsumer & Serializable)json -> {
            ObjectNode responseJson;
            if (json.getNodeType() == JsonNodeType.STRING) {
                responseJson = JacksonUtils.createObjectNode();
                responseJson.put("message", json.asString());
            } else {
                responseJson = JacksonUtils.readTree((String)json.toString());
            }
            if (responseJson.has("message")) {
                receiver.subscription(null);
            } else {
                receiver.subscription(this.generateSubscription(responseJson));
            }
        };
    }

    private WebPushSubscription generateSubscription(ObjectNode subscriptionJson) {
        WebPushKeys keys = new WebPushKeys(subscriptionJson.get("keys").get("p256dh").asString(), subscriptionJson.get("keys").get("auth").asString());
        return new WebPushSubscription(subscriptionJson.get("endpoint").asString(), keys);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(WebPush.class);
    }
}

