/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webpush;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;

public record WebPushMessage(String title, ObjectNode options) implements Serializable
{
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public WebPushMessage(String title, Serializable options) {
        this(title, (ObjectNode)objectMapper.convertValue((Object)options, ObjectNode.class));
    }

    public WebPushMessage(String title, String body) {
        this(title, WebPushMessage.getBodyOption(body));
    }

    public WebPushMessage(String title) {
        this(title, (ObjectNode)null);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("title", this.title);
        if (this.options != null) {
            json.set("options", (JsonNode)this.options);
        }
        return json.toString();
    }

    private static ObjectNode getBodyOption(String body) {
        ObjectNode objectNode = objectMapper.createObjectNode();
        if (body != null) {
            objectNode.put("body", body);
        }
        return objectNode;
    }
}

