/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testutil.ChromeBrowserTest;
import com.vaadin.flow.testutil.LocalExecution;
import com.vaadin.flow.testutil.TestBenchHelpers;
import com.vaadin.testbench.IPAddress;
import com.vaadin.testbench.annotations.BrowserConfiguration;
import com.vaadin.testbench.annotations.BrowserFactory;
import com.vaadin.testbench.annotations.RunLocally;
import com.vaadin.testbench.annotations.RunOnHub;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

@RunOnHub
@RunLocally
@BrowserFactory(value=DefaultBrowserFactory.class)
@LocalExecution
public class AbstractParallelTestBenchTest
extends TestBenchHelpers {
    private static final String DEFAULT_SERVER_PORT = "8888";
    public static final String SERVER_PORT_PROPERTY_KEY = "serverPort";
    public static final int SERVER_PORT = Integer.parseInt(System.getProperty("serverPort", "8888"));
    public static final String USE_HUB_PROPERTY = "test.use.hub";
    public static final boolean USE_HUB = Boolean.TRUE.toString().equals(System.getProperty("test.use.hub", "false"));

    @Before
    public void setup() throws Exception {
        if (USE_HUB) {
            this.setDesiredCapabilities(Browser.CHROME.getDesiredCapabilities());
        } else if (Browser.CHROME == this.getRunLocallyBrowser() && !ChromeBrowserTest.isJavaInDebugMode()) {
            this.setDriver(ChromeBrowserTest.createHeadlessChromeDriver(this::updateHeadlessChromeOptions));
            return;
        }
        super.setup();
    }

    protected void updateHeadlessChromeOptions(ChromeOptions chromeOptions) {
    }

    protected String getRootURL() {
        return "http://" + this.getDeploymentHostname() + ":" + this.getDeploymentPort();
    }

    protected int getDeploymentPort() {
        return SERVER_PORT;
    }

    protected Optional<LocalExecution> getLocalExecution() {
        if (USE_HUB) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Object)((Object)this)).getClass().getAnnotation(LocalExecution.class)).filter(LocalExecution::active);
    }

    protected Browser getRunLocallyBrowser() {
        if (USE_HUB) {
            return null;
        }
        return Browser.CHROME;
    }

    protected String getDeploymentHostname() {
        if (this.getLocalExecution().isPresent()) {
            return "localhost";
        }
        return IPAddress.findSiteLocalAddress();
    }

    @BrowserConfiguration
    public List<DesiredCapabilities> getBrowsersToTest() {
        if (this.getLocalExecution().isPresent()) {
            return this.getBrowserCapabilities(this.getLocalExecution().get().value());
        }
        return this.getHubBrowsersToTest();
    }

    protected List<DesiredCapabilities> getHubBrowsersToTest() {
        return this.getBrowserCapabilities(Browser.CHROME);
    }

    protected List<DesiredCapabilities> getBrowserCapabilities(Browser ... browsers) {
        ArrayList<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
        for (Browser browser : browsers) {
            capabilities.add(browser.getDesiredCapabilities());
        }
        return capabilities;
    }
}

